/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.complex3d.AppletComplex3D;
import uibk.applets.complex3d.FunctionAbs;
import uibk.applets.complex3d.FunctionImagPart;
import uibk.applets.complex3d.FunctionRealPart;
import uibk.applets.complex3d.Messages;
import uibk.mtk.draw3d.objects.surface3d.Function2DMeshBuilder;
import uibk.mtk.draw3d.objects.surface3d.Mesh;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ComplexFunction;
import uibk.mtk.math.functions.Function2D;
import uibk.mtk.math.parsing.ComplexFunctionParser;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.MPanel;

public class PanelSurface
extends MPanel
implements ActionListener {
    JTextField textFunction = new JTextField();
    JButton buttonCalc;
    JSlider sliderMeshPoints;
    JLabel labelmesh;
    JLabel labeldomain;
    AppletComplex3D main;
    IntervalTextField txtIntervalReal;
    IntervalTextField txtIntervalImag;

    public PanelSurface(AppletComplex3D main) {
        this.main = main;
        this.initComponents();
    }

    private ComplexFunction getFunction() {
        try {
            return ComplexFunctionParser.parse('z', this.textFunction.getText());
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(Messages.getString("ErrorInFunction"), e);
            return null;
        }
    }

    private Function2D getFunction2D(ComplexFunction f) {
        if (this.main.panelplottype.optAbs.isSelected()) {
            return new FunctionAbs(f);
        }
        if (this.main.panelplottype.optImagPart.isSelected()) {
            return new FunctionImagPart(f);
        }
        return new FunctionRealPart(f);
    }

    void compute() {
        Interval intervalimag;
        Interval intervalreal;
        ComplexFunction function = this.getFunction();
        if (function == null) {
            return;
        }
        int n = this.sliderMeshPoints.getValue();
        try {
            intervalreal = this.txtIntervalReal.getInterval();
            intervalimag = this.txtIntervalImag.getInterval();
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(e);
            return;
        }
        CoordinateRect2D limits = new CoordinateRect2D(intervalreal.a, intervalreal.b, intervalimag.a, intervalimag.b);
        Function2D f = this.getFunction2D(function);
        try {
            Function2DMeshBuilder meshbuilder = new Function2DMeshBuilder(f);
            Mesh mesh = meshbuilder.build(limits, n, n, true);
            this.main.surface3d.setMesh(mesh);
        }
        catch (Exception e) {
            this.main.surface3d.setVisible(false);
            this.main.mathpanel3d.getScene3D().setBoundingBox(new CoordinateBox3D());
            this.main.mathpanel3d.reportError(e);
            return;
        }
        CoordinateBox3D box = this.main.surface3d.getBoundingBox();
        this.main.mathpanel3d.getScene3D().setBoundingBox(box);
        this.main.surface3d.setVisible(true);
        this.main.mathpanel3d.reportSuccess(f + Messages.getString("Drawn"));
        this.main.mathpanel3d.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals(Messages.getString("Compute"))) {
            this.compute();
            this.main.mathpanel3d.repaint();
        }
    }

    void initComponents() {
        TitledBorder border = BorderFactory.createTitledBorder(Messages.getString("EnterSurface"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 320));
        int n = 20;
        this.labelmesh = new JLabel(String.valueOf(Messages.getString("NumberOfGridPoints")) + n + "x" + n);
        this.labelmesh.setFont(this.labelmesh.getFont().deriveFont(1));
        this.labeldomain = new JLabel(Messages.getString("Domain"));
        this.labeldomain.setFont(this.labeldomain.getFont().deriveFont(1));
        this.textFunction = new JTextField(10);
        this.textFunction.setActionCommand(Messages.getString("Compute"));
        this.textFunction.addActionListener(this);
        this.textFunction.setToolTipText(Messages.getString("EnterFormulaOfComplexFunction"));
        this.txtIntervalImag = new IntervalTextField(10, Messages.getString("IntervalImaginaryPart"), true);
        this.txtIntervalImag.setActionCommand(Messages.getString("Compute"));
        this.txtIntervalImag.addActionListener(this);
        this.txtIntervalImag.setToolTipText(Messages.getString("EnterIntervalImaginaryPart"));
        this.txtIntervalReal = new IntervalTextField(10, Messages.getString("IntervalRealPart"), true);
        this.txtIntervalReal.setActionCommand(Messages.getString("Compute"));
        this.txtIntervalReal.addActionListener(this);
        this.txtIntervalReal.setToolTipText(Messages.getString("EnterIntervalRealPart"));
        this.buttonCalc = new JButton(Messages.getString("Draw"));
        this.buttonCalc.setActionCommand(Messages.getString("Compute"));
        this.buttonCalc.addActionListener(this);
        this.buttonCalc.setToolTipText(Messages.getString("ComputeAndPlotSurface"));
        JLabel labelFormula = new JLabel("f(z)=");
        this.sliderMeshPoints = new JSlider();
        this.sliderMeshPoints.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelSurface.this.labelmesh.setText(String.valueOf(Messages.getString("NumberOfGridPoints")) + String.valueOf(n) + "x" + String.valueOf(n));
            }
        });
        this.sliderMeshPoints.setMinimum(3);
        this.sliderMeshPoints.setMaximum(40);
        this.sliderMeshPoints.setValue(20);
        this.add((Component)labelFormula, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.textFunction, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.labelmesh, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.sliderMeshPoints, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 20, 5), 0, 0));
        this.add((Component)this.labeldomain, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("ReZ")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.txtIntervalReal, new GridBagConstraints(1, 5, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("ImZ")), new GridBagConstraints(0, 6, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.txtIntervalImag, new GridBagConstraints(1, 6, 1, 1, 2.0, 0.0, 17, 0, new Insets(0, 0, 15, 5), 0, 0));
        this.add((Component)this.buttonCalc, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
    }
}

