/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import uibk.mtk.swing.datatable.MyAbstractTableModel;

public class TableModelWithRowNames
extends MyAbstractTableModel {
    private final String[] rowNames;

    public TableModelWithRowNames(double[][] data, String[] rowNames) {
        super(data);
        if (data != null && rowNames.length != data[0].length + 1) {
            throw new IllegalArgumentException("");
        }
        this.rowNames = rowNames;
    }

    public TableModelWithRowNames(int rows, int cols, String[] rowNames) {
        super(rows, cols);
        if (rowNames.length != rows) {
            throw new IllegalArgumentException("");
        }
        this.rowNames = rowNames;
    }

    public int getColumnCount() {
        if (this.columnnames != null) {
            return this.columnnames.length + 1;
        }
        if (this.datagrid == null || this.datagrid.isEmpty()) {
            return 0;
        }
        return this.datagrid.getColumns() + 1;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.rowNames[0];
        }
        if (this.columnnames == null) {
            return "x" + columnIndex;
        }
        return this.columnnames[columnIndex - 1];
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return;
        }
        try {
            double d = Double.parseDouble(aValue.toString());
            this.datagrid.setValue(new Double(d), rowIndex, columnIndex - 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.rowNames[row + 1];
        }
        Object obj = this.datagrid.getValue(row, col - 1);
        if (obj == null) {
            return "";
        }
        return obj;
    }
}

