/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.functions;

import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom2d.Vector2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.ParametricCurve2D;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.functions.SingularPointException;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Variable;

public class ParsedParametricCurve2D
extends ParsedFunction
implements ParametricCurve2D {
    private static final String BUNDLE_NAME = "uibk.mtk.math.functions.messages";

    public ParsedParametricCurve2D(Variable[] variables, Expr[] functions) {
        super(variables, functions);
    }

    public Punkt2D calcPoint(double param) {
        double[] v = this.getValue(new double[]{param});
        return new Punkt2D(v[0], v[1]);
    }

    public Vector2D velocityVector(double t) throws Exception {
        if (this.n != 1) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "ParsedParametricCurve2D.0"));
        }
        double[][] jacob = this.getJacobian(new double[]{t});
        double x = jacob[0][0];
        double y = jacob[1][0];
        if (this.checkdiff) {
            double esterror = this.getEstimatedErrorFirstDeriv(t);
            if (Math.sqrt(x * x + y * y) < esterror / 100.0) {
                throw new SingularPointException(Messages.getString(BUNDLE_NAME, "ParsedParametricCurve2D.1"));
            }
        }
        return new Vector2D(x, y);
    }

    public Vector2D accelerationVector(double t) throws Exception {
        double[] a = super.getDerivation2(new double[]{t});
        return new Vector2D(a[0], a[1]);
    }
}

