/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussNewton;

import Jama.Matrix;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import uibk.applets.gaussNewton.AppletGaussNewton;
import uibk.applets.gaussNewton.Model;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.objects.PointPlot2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.util.IntervalIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelOption
extends MPanel
implements ActionListener {
    private static final int POINTS = 100;
    private static final Color COLOR_GRAPH = Color.blue;
    private static final Color COLOR_HISTORY = Color.lightGray;
    private static final Color COLOR_POINTS = new Color(20, 100, 20);
    private static final Color COLOR_STEP = Color.black;
    private static final int RADIUS_POINTS = 3;
    private static final int RADIUS_STEP = 4;
    private final AppletGaussNewton main;
    private Model model;
    private final MathPanel2D mathpanel2d = new MathPanel2D();
    private PointPlot2D graph2D;
    private final Vector<Vector<Punkt2D>> function2D = new Vector();
    private final Vector<PointPlot2D> old_graph2d = new Vector();
    private final Axes2D axes2D = new Axes2D();
    private final PointPlot2D pointPlot = new PointPlot2D();
    private final Vector<Punkt2D> err = new Vector();
    private final Vector<Punkt2D> dx = new Vector();
    private Type type = Type.off;
    private final JCheckBox lineSearch = new JCheckBox(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.30"));
    private final DoubleTextField textTol = new DoubleTextField(5, null, null, Boolean.TRUE, Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.0"));
    private final IntegerTextField textMaxStep = new IntegerTextField(5, 0, null, Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.1"));

    public PanelOption(AppletGaussNewton main) {
        this.main = main;
        this.graph2D = this.newGraph(0);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.initOption());
        this.add(this.initType());
        this.mathpanel2d.setToolTipText("");
        this.mathpanel2d.getScene2d().setRoundingPercent(20.0);
        this.pointPlot.setPointRadius(3);
        this.pointPlot.setColor(COLOR_POINTS);
        this.mathpanel2d.add(this.axes2D);
        this.mathpanel2d.add(this.graph2D);
        this.graph2D.setLineColor(COLOR_GRAPH);
        this.graph2D.setColor(COLOR_STEP);
    }

    private Component initType() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.4"));
        panel.setLayout(new GridLayout(2, 2));
        panel.setMaximumSize(new Dimension(10000, 120));
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            panel.add(t.getRadioButton(this));
            ++n2;
        }
        return panel;
    }

    public void clearPlot(Model model, Matrix t) {
        this.model = model;
        this.setPoints();
        this.err.removeAllElements();
        this.dx.removeAllElements();
        this.function2D.removeAllElements();
        this.actionPerformed(new ActionEvent(this, 0, this.type.bez));
    }

    private void setPoints() {
        this.mathpanel2d.add(this.pointPlot);
        this.pointPlot.clearpoints();
        if (this.model.getDimVar() != 1) {
            return;
        }
        int indexDep = this.model.getIndexDependedVar();
        int indexInd = (indexDep + 1) % 2;
        double[][] data = this.model.getData();
        int i = 0;
        while (i < data[0].length) {
            this.pointPlot.addPoint(new Punkt2D(data[indexInd][i], data[indexDep][i]));
            ++i;
        }
        this.mathpanel2d.delete(this.pointPlot);
    }

    public void set(int it, Matrix f, Matrix dx, Matrix t) {
        double err = Math.log10(f.norm2());
        this.err.add(new Punkt2D(it, err));
        double dx_norm = -1.0;
        if (dx != null) {
            dx_norm = Math.log10(dx.norm2());
            this.dx.add(new Punkt2D(it, dx_norm));
        }
        Vector<Punkt2D> points = null;
        if (this.model.getDimVar() != 1 && !this.type.equals((Object)Type.off) && this.type.equals((Object)Type.fun)) {
            this.type = Type.off;
            this.actionPerformed(new ActionEvent(this, 0, this.type.bez));
        } else if (this.model.getDimVar() == 1) {
            points = this.getFunction(t.getArray()[0]);
            this.function2D.add(points);
        }
        switch (this.type) {
            case err: {
                this.graph2D.addPoint(new Punkt2D(it, err));
                this.mathpanel2d.getScene2d().setLimits(this.getLimits(this.graph2D));
                this.mathpanel2d.repaint();
                break;
            }
            case dx: {
                if (dx == null) break;
                this.graph2D.addPoint(new Punkt2D(it, dx_norm));
                this.mathpanel2d.getScene2d().setLimits(this.getLimits(this.graph2D));
                this.mathpanel2d.repaint();
                break;
            }
            case fun: {
                if (this.function2D.size() > 1) {
                    this.graph2D.setLineColor(COLOR_HISTORY);
                    this.graph2D.setColor(COLOR_HISTORY);
                    this.old_graph2d.add(this.graph2D);
                    this.graph2D = this.newGraph(0);
                    this.mathpanel2d.add(this.graph2D);
                }
                this.graph2D.setPoints(new Vector<Punkt2D>(points));
                CoordinateRect2D limits = this.getLimits(this.graph2D).combine(this.getLimits(this.pointPlot));
                for (Graph2D graph2D : this.old_graph2d) {
                    limits = limits.combine(this.getLimits(graph2D));
                }
                this.mathpanel2d.getScene2d().setLimits(limits);
                this.mathpanel2d.add(this.pointPlot);
                this.mathpanel2d.repaint();
                break;
            }
        }
    }

    private CoordinateRect2D getLimits(Graph2D graph) {
        Punkt2D p;
        CoordinateRect2D limits = graph.getLimits();
        Vector points = graph.getPoints();
        if (Double.isInfinite(limits.xmax)) {
            p = this.getFinitMax(points);
            limits.xmax = p.x + Math.abs(p.x);
        }
        if (Double.isInfinite(limits.ymax)) {
            p = this.getFinitMax(points);
            limits.ymax = p.y + Math.abs(p.y);
        }
        if (Double.isInfinite(limits.xmin)) {
            p = this.getFinitMin(points);
            limits.xmin = p.x - Math.abs(p.x);
        }
        if (Double.isInfinite(limits.ymin)) {
            p = this.getFinitMin(points);
            limits.ymin = p.y - Math.abs(p.y);
        }
        return limits;
    }

    private Punkt2D getFinitMax(Vector points) {
        Punkt2D pp = this.getPunkt2D(points.firstElement());
        Punkt2D p = new Punkt2D(pp.x, pp.y);
        int i = 1;
        while (i < points.size()) {
            pp = this.getPunkt2D(points.elementAt(i));
            if (!Double.isInfinite(pp.x) && p.x < pp.x) {
                p.x = pp.x;
            }
            if (!Double.isInfinite(pp.y) && p.y < pp.y) {
                p.y = pp.y;
            }
            ++i;
        }
        return p;
    }

    private Punkt2D getFinitMin(Vector points) {
        Punkt2D pp = this.getPunkt2D(points.firstElement());
        Punkt2D p = new Punkt2D(pp.x, pp.y);
        int i = 1;
        while (i < points.size()) {
            pp = this.getPunkt2D(points.elementAt(i));
            if (!Double.isInfinite(pp.x) && p.x > pp.x) {
                p.x = pp.x;
            }
            if (!Double.isInfinite(pp.y) && p.y > pp.y) {
                p.y = pp.y;
            }
            ++i;
        }
        return p;
    }

    private PointPlot2D newGraph(int radius) {
        PointPlot2D pointPlot = new PointPlot2D();
        pointPlot.setPointRadius(radius);
        pointPlot.connectPoints(true);
        pointPlot.setLineColor(COLOR_GRAPH);
        if (radius == 0) {
            pointPlot.setColor(COLOR_GRAPH);
        } else {
            pointPlot.setColor(COLOR_STEP);
        }
        return pointPlot;
    }

    public Punkt2D getPunkt2D(Object o) {
        if (o instanceof Punkt2D) {
            return (Punkt2D)o;
        }
        if (o instanceof MathPoint2D) {
            return new Punkt2D(((MathPoint2D)o).getX(), ((MathPoint2D)o).getY());
        }
        throw new IllegalArgumentException();
    }

    private Vector<Punkt2D> getFunction(double[] t) {
        if (this.model.getDimVar() != 1) {
            return null;
        }
        Vector<Punkt2D> ret = new Vector<Punkt2D>();
        double x0 = this.model.getMin()[(this.model.getIndexDependedVar() + 1) % 2];
        double x1 = this.model.getMax()[(this.model.getIndexDependedVar() + 1) % 2];
        IntervalIterator it = new IntervalIterator(x0, x1, 100);
        while (it.hasNext()) {
            double[] x = new double[]{it.nextdouble()};
            ret.add(new Punkt2D(x[0], this.model.getVaule(x, t)));
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mathpanel2d.delete(this.pointPlot);
        for (Graph2D graph2D : this.old_graph2d) {
            this.mathpanel2d.delete(graph2D);
        }
        this.old_graph2d.removeAllElements();
        this.graph2D.clearpoints();
        Type type = Type.getTypForBez(e.getActionCommand());
        switch (type) {
            case err: {
                this.plotErr();
                break;
            }
            case dx: {
                this.plotDx();
                break;
            }
            case fun: {
                this.plotFun();
                break;
            }
            case off: {
                this.main.display(null);
                break;
            }
        }
        this.type = type;
        this.mathpanel2d.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private void plotFun() {
        if (this.model == null || this.model.getDimVar() != 1) {
            this.main.display(null);
            return;
        }
        this.graph2D.setPointRadius(0);
        this.graph2D.setLineColor(COLOR_GRAPH);
        this.graph2D.setColor(COLOR_GRAPH);
        this.axes2D.setCaptionXAxis("x" + (this.model.getIndexDependedVar() + 1) % 2);
        this.axes2D.setCaptionYAxis("x" + this.model.getIndexDependedVar());
        this.mathpanel2d.add(this.pointPlot);
        CoordinateRect2D limits = this.getLimits(this.pointPlot);
        if (this.function2D.size() > 0) {
            void var2_3;
            boolean bl = false;
            while (var2_3 < this.function2D.size() - 1) {
                PointPlot2D g = this.newGraph(0);
                this.mathpanel2d.add(g);
                g.setLineColor(COLOR_HISTORY);
                g.setColor(COLOR_HISTORY);
                g.setPoints(this.function2D.get((int)var2_3));
                this.old_graph2d.add(g);
                ++var2_3;
            }
            this.mathpanel2d.delete(this.graph2D);
            this.graph2D.setPoints(new Vector(this.function2D.lastElement()));
            limits = limits.combine(this.getLimits(this.graph2D));
            this.graph2D.setPointRadius(0);
            this.mathpanel2d.add(this.graph2D);
        }
        this.main.display(this.mathpanel2d);
        for (Graph2D graph2D : this.old_graph2d) {
            limits = limits.combine(this.getLimits(graph2D));
        }
        this.mathpanel2d.getScene2d().setLimits(limits);
    }

    private void plotDx() {
        this.graph2D.setPointRadius(4);
        this.graph2D.setLineColor(COLOR_GRAPH);
        this.graph2D.setColor(COLOR_STEP);
        this.axes2D.setCaptionXAxis(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.10"));
        this.axes2D.setCaptionYAxis(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.11"));
        for (Punkt2D p : this.dx) {
            this.graph2D.addPoint(p);
        }
        this.mathpanel2d.getScene2d().setLimits(this.getLimits(this.graph2D));
        this.main.display(this.mathpanel2d);
    }

    private void plotErr() {
        this.graph2D.setPointRadius(4);
        this.graph2D.setLineColor(COLOR_GRAPH);
        this.graph2D.setColor(COLOR_STEP);
        this.axes2D.setCaptionXAxis(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.10"));
        this.axes2D.setCaptionYAxis(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.12"));
        for (Punkt2D p : this.err) {
            this.graph2D.addPoint(p);
        }
        this.mathpanel2d.getScene2d().setLimits(this.getLimits(this.graph2D));
        this.main.display(this.mathpanel2d);
    }

    public Component initOption() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.2"));
        panel.setMaximumSize(new Dimension(1000, 100));
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.0")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.textTol, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.1")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.textMaxStep, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.lineSearch.setSelected(false);
        panel.add((Component)this.lineSearch, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setTol(Double tol) {
        this.textTol.setText(tol.toString());
    }

    public double getTol() throws Exception {
        return this.textTol.getValue();
    }

    public void setMaxStep(Integer maxStep) {
        this.textMaxStep.setText(maxStep.toString());
    }

    public int getMaxStep() throws Exception {
        return this.textMaxStep.getValue();
    }

    public boolean isLineSearch() {
        return this.lineSearch.isSelected();
    }

    public void setLineSearch(boolean b) {
        this.lineSearch.setSelected(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        err(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.0")),
        dx(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.1")),
        fun(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.2")),
        off(Messages.getString("uibk.applets.gaussNewton.messages", "PanelPlot.3"));

        private final String bez;
        private static final ButtonGroup group;

        static {
            group = new ButtonGroup();
        }

        private Type(String bez) {
            this.bez = bez;
        }

        public JRadioButton getRadioButton(ActionListener a) {
            JRadioButton b = new JRadioButton(this.bez);
            b.addActionListener(a);
            b.setActionCommand(this.bez);
            group.add(b);
            if (this.equals((Object)off)) {
                b.setSelected(true);
            }
            return b;
        }

        public static Type getTypForBez(String bez) {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                if (t.bez.equals(bez)) {
                    return t;
                }
                ++n2;
            }
            return null;
        }
    }
}

