/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussNewton;

import Jama.Matrix;
import java.util.Vector;
import uibk.applets.gaussNewton.PanelModel;
import uibk.mtk.math.functions.Function;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.FunctionParser;
import uibk.mtk.swing.datatable.DataTable;

public class Model
extends Function {
    private ParsedFunction f = null;
    private int dimPar = 0;
    private int dimVar = 0;
    private int indexDependedVar = 0;
    private double[][] data = null;
    private double[] min = null;
    private double[] max = null;

    public Model() {
        super(0, 0);
        this.init();
    }

    private void init() {
        this.dimPar = 0;
        this.dimVar = 0;
        this.n = 0;
        this.data = null;
        this.checkdiff = false;
    }

    public Matrix readData(DataTable table, PanelModel panelFunction) throws Exception {
        this.data = table.getData();
        if (this.data == null || this.data.length == 0 || this.data[0] == null || this.data[0].length == 0) {
            this.init();
            return null;
        }
        String[] fct = panelFunction.getFunction();
        this.indexDependedVar = panelFunction.getDependentVar(table.getColumnCount()) - 1;
        this.dimVar = this.indexDependedVar < 0 ? this.data.length : this.data.length - 1;
        Vector<String> var = panelFunction.getParameter();
        this.dimPar = var.size();
        int i = table.getColumnCount() - 1;
        while (i >= 1) {
            if (i != this.indexDependedVar + 1) {
                var.add(0, "x" + i);
            }
            --i;
        }
        this.min = new double[this.data.length];
        this.max = new double[this.data.length];
        i = 0;
        while (i < this.data.length) {
            this.min[i] = this.max[i] = this.data[i][0];
            ++i;
        }
        i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[0].length) {
                if (this.data[i][j] < this.min[i]) {
                    this.min[i] = this.data[i][j];
                }
                if (this.data[i][j] > this.max[i]) {
                    this.max[i] = this.data[i][j];
                }
                ++j;
            }
            ++i;
        }
        this.f = FunctionParser.parseFunction(var.toArray(new String[0]), fct);
        super.setDim(this.data[0].length * this.f.getNumberFunctions(), this.dimPar);
        return panelFunction.getInitialPoint(this.dimPar);
    }

    public Matrix getValue(Matrix t) {
        return new Matrix(new double[][]{this.getValue(t.getArray()[0])});
    }

    public double[] getValue(double[] t) {
        if (this.data == null) {
            return null;
        }
        if (t.length != this.dimPar) {
            throw new IllegalArgumentException("Interner Fehler: Ung\u00fcltige l\u00e4nge von t");
        }
        double[] ret = new double[this.m];
        double[] x = new double[this.dimPar + this.dimVar];
        System.arraycopy(t, 0, x, this.dimVar, this.dimPar);
        int i = 0;
        while (i < this.m) {
            int k = 0;
            int j = 0;
            while (j < this.dimVar + (this.indexDependedVar < 0 ? 0 : 1)) {
                if (j != this.indexDependedVar) {
                    x[j - k] = this.data[j][i / this.f.getNumberFunctions()];
                } else {
                    k = 1;
                }
                ++j;
            }
            if (this.indexDependedVar < 0) {
                double[] tmp = this.f.getValue(x);
                int j2 = 0;
                while (j2 < this.f.getNumberFunctions()) {
                    ret[i + j2] = tmp[j2];
                    ++j2;
                }
                i += this.f.getNumberFunctions() - 1;
            } else {
                ret[i] = this.f.getValue(x)[0] - this.data[this.indexDependedVar][i];
            }
            ++i;
        }
        return ret;
    }

    public double getVaule(double[] x, double[] t) {
        if (t.length != this.dimPar || x.length != this.dimVar) {
            throw new IllegalArgumentException("Interner Fehler: Ung\u00fcltige l\u00e4nge von t oder x");
        }
        double[] x_in = new double[this.dimVar + this.dimPar];
        System.arraycopy(x, 0, x_in, 0, this.dimVar);
        System.arraycopy(t, 0, x_in, this.dimVar, this.dimPar);
        return this.f.getValue(x_in)[0];
    }

    public int getDimPar() {
        return this.dimPar;
    }

    public int getDimVar() {
        return this.dimVar;
    }

    public int getIndexDependedVar() {
        return this.indexDependedVar;
    }

    public double[][] getData() {
        return this.data;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getMax() {
        return this.max;
    }
}

