/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.DragablePoint2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.util.GraphUtil;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.lang.Clickable;
import uibk.mtk.lang.Dragable;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.Interval;
import uibk.mtk.math.RandomUtil;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.util.IntervalIterator;

public class Integration2DVisualisation
extends Drawable2D
implements PrepaintComputable,
Dragable,
Clickable {
    private Color edgecolor = new Color(200, 200, 200, 130);
    Function1D function;
    private Color pointcolor = Color.darkGray;
    private Color negativecolor = new Color(174, 215, 255);
    private Color shapecolor = new Color(255, 255, 0, 100);
    Color errorcolor = new Color(255, 100, 100, 100);
    boolean intervalsenabled;
    int pointradius = 1;
    double sum;
    double sum2;
    Dragable dragged = null;
    public static final int RULE_UPPERSUM = 0;
    public static final int RULE_LOWERSUM = 1;
    public static final int RULE_MIDPOINT = 3;
    public static final int RULE_TRAPEZOID = 4;
    public static final int RULE_UPPER_AND_LOWER = 5;
    public static final int RULE_LEFT_POINT = 6;
    public static final int RULE_RIGHT_POINT = 7;
    public static final int RULE_RIEMANN = 8;
    private int method = 8;
    Vector shapes = new Vector();
    Interval interval = new Interval(0.0, 1.0);
    Graph2D graph = new Graph2D();
    int numpointsgraph = 400;
    Vector points = new Vector();
    Vector sepp = new Vector();
    int n = 10;
    boolean negative_samecolor = true;
    private double xl;
    private double xr;
    private double xleft;
    private double xright;
    private int yPix0;
    private int xPixLeft;
    private int xPixRight;
    private int yPixFLeft;
    private int yPixFRight;
    private double h;
    private double xm;

    public Integration2DVisualisation() {
        this.graph.setColor(Color.blue);
        this.setColor(this.shapecolor);
    }

    @Override
    public boolean isDragEnabled() {
        return this.intervalsenabled;
    }

    private void leftandright() {
        int k = this.points.size();
        int i = 0;
        while (i < k) {
            IntervalPoint p = (IntervalPoint)this.points.elementAt(i);
            if (i < k - 1) {
                p.right = (IntervalPoint)this.points.elementAt(i + 1);
            }
            if (i > 0) {
                p.left = (IntervalPoint)this.points.elementAt(i - 1);
            }
            ++i;
        }
        IntervalPoint p = (IntervalPoint)this.points.elementAt(k - 1);
        p.right = null;
    }

    public void enableIntervals(boolean enable) {
        this.intervalsenabled = enable;
    }

    private void addNewIntervallPoint(double x) {
        if (this.points.size() == 0) {
            this.points.add(0, this.createpoint(x));
            return;
        }
        if (this.points.size() == 1) {
            IntervalPoint p = (IntervalPoint)this.points.elementAt(0);
            if (x > p.getX()) {
                this.points.add(1, this.createpoint(x));
            } else {
                this.points.add(0, this.createpoint(x));
            }
            return;
        }
        double min = ((IntervalPoint)this.points.elementAt(0)).getX();
        double max = ((IntervalPoint)this.points.elementAt(this.points.size() - 1)).getX();
        if (x < min) {
            this.points.add(0, this.createpoint(x));
            return;
        }
        if (x > max) {
            this.points.add(this.points.size(), this.createpoint(x));
            return;
        }
        ListIterator it = this.points.listIterator();
        MathPoint2D last = null;
        int i = 0;
        while (it.hasNext()) {
            IntervalPoint p = (IntervalPoint)it.next();
            if (last != null && x > last.getX() && x < p.getX()) {
                this.points.add(i, this.createpoint(x));
                return;
            }
            ++i;
            last = p;
        }
    }

    @Override
    public boolean clickcontains(int x, int y) {
        double xx = this.scene2d.pixelToX(x);
        if (xx < this.interval.a || xx > this.interval.b) {
            return false;
        }
        return this.scene2d.yToPixel(0.0) - y <= 10;
    }

    @Override
    public void click(MouseEvent ev) {
        if (!this.intervalsenabled) {
            return;
        }
        double x = this.scene2d.pixelToX(ev.getX());
        if (this.onlyRightButton(ev)) {
            this.addNewIntervallPoint(x);
        }
        if (this.onlyMiddleButton(ev)) {
            ListIterator it = this.points.listIterator();
            while (it.hasNext()) {
                IntervalPoint p = (IntervalPoint)it.next();
                if (!p.dragcontains(ev.getX(), ev.getY())) continue;
                it.remove();
                break;
            }
        }
        this.leftandright();
        this.computesum();
        this.panel.repaint();
    }

    private boolean onlyLeftButton(MouseEvent ev) {
        return ev.getModifiers() == 16;
    }

    private boolean onlyRightButton(MouseEvent ev) {
        return ev.getModifiers() == 4;
    }

    private boolean onlyMiddleButton(MouseEvent ev) {
        return ev.getModifiers() == 8;
    }

    public boolean intervalsEnabled() {
        return this.intervalsenabled;
    }

    @Override
    public void drag(MouseEvent ev) {
        if (!this.intervalsenabled || !this.onlyLeftButton(ev)) {
            return;
        }
        this.dragged.drag(ev);
        this.computesum();
    }

    @Override
    public boolean dragcontains(int xm, int ym) {
        for (DragablePoint2D mathpoint : this.points) {
            if (!mathpoint.dragcontains(xm, ym)) continue;
            this.dragged = mathpoint;
            return true;
        }
        return false;
    }

    @Override
    public void enabledrag(boolean enable) {
    }

    public void setFunction(Function1D func) {
        this.function = func;
    }

    public void setMethod(int m) {
        if (this.method != m) {
            this.method = m;
            this.computesum();
        }
    }

    public void setInterval(Interval inter) {
        this.interval = (Interval)inter.clone();
    }

    public void setNumberSubDivisions(int size) {
        if (size != this.n) {
            this.computesum();
            this.n = size;
        }
    }

    private void createIntervalPoints() {
        this.points.clear();
        IntervalIterator it = new IntervalIterator(this.interval, this.n + 1);
        while (it.hasNext()) {
            IntervalPoint p = this.createpoint(it.nextdouble());
            this.points.add(p);
        }
        this.leftandright();
    }

    IntervalPoint createpoint(double x) {
        IntervalPoint p = new IntervalPoint(x);
        p.setColor(this.pointcolor);
        p.setRadius(this.pointradius);
        p.setMathPanel2D(this.panel);
        return p;
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        this.graph.setMathPanel2D(panel);
    }

    @Override
    public void prepaintcompute() throws Exception {
        if (this.method == 8) {
            this.createP();
        }
        this.computeshapes();
    }

    private void computeshapes() {
        this.shapes.clear();
        Iterator it = this.points.iterator();
        IntervalPoint last = null;
        while (it.hasNext()) {
            IntervalPoint p = (IntervalPoint)it.next();
            p.x_pix = this.scene2d.xToPixel(p.x);
            p.y_pix = this.scene2d.yToPixel(this.function.getValue(p.x));
        }
        Iterator it2 = this.sepp.iterator();
        this.yPix0 = this.scene2d.yToPixel(0.0);
        for (IntervalPoint mathpoint : this.points) {
            if (last != null) {
                this.xl = last.getX();
                this.xr = mathpoint.getX();
                this.yPixFLeft = last.y_pix;
                this.xPixLeft = last.x_pix;
                this.yPixFRight = mathpoint.y_pix;
                this.xPixRight = mathpoint.x_pix;
                if (this.method == 8) {
                    this.xm = ((IntervalPoint)it2.next()).getX();
                }
                switch (this.method) {
                    case 8: {
                        this.addRiemannShape();
                        break;
                    }
                    case 1: {
                        this.addLowerSumShape();
                        break;
                    }
                    case 0: {
                        this.addUpperSumShape();
                        break;
                    }
                    case 3: {
                        this.addMidPointShape();
                        break;
                    }
                    case 4: {
                        this.addTrapezoidShape();
                        break;
                    }
                    case 5: {
                        this.addUpperLowerShape();
                        break;
                    }
                    case 7: {
                        this.addRightPointShape();
                        break;
                    }
                    case 6: {
                        this.addLeftPointShape();
                    }
                }
            }
            last = mathpoint;
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        for (MyPolygon shape : this.shapes) {
            g2.setColor(shape.fillcolor);
            g2.fill(shape);
            g2.setColor(this.edgecolor);
            g2.draw(shape);
        }
        this.graph.draw(framebuffer, g2);
        if (this.intervalsenabled) {
            for (DragablePoint2D mathpoint : this.points) {
                mathpoint.draw(framebuffer, g2);
            }
            if (this.method == 8) {
                for (DragablePoint2D mathpoint : this.sepp) {
                    mathpoint.draw(framebuffer, g2);
                }
            }
        }
    }

    private void createP() {
        this.sepp.clear();
        Iterator it = this.points.iterator();
        IntervalPoint last = null;
        while (it.hasNext()) {
            IntervalPoint p = (IntervalPoint)it.next();
            if (last != null) {
                IntervalPoint s = new IntervalPoint(RandomUtil.rand((double)last.getX(), (double)p.getX()));
                s.setMathPanel2D(this.panel);
                s.setColor(Color.blue);
                this.sepp.add(s);
            }
            last = p;
        }
    }

    public void create() throws Exception {
        this.createIntervalPoints();
        this.graph.setPoints(GraphUtil.compute(this.function, this.interval.a, this.interval.b, this.numpointsgraph));
        this.computesum();
        this.computeshapes();
    }

    public CoordinateRect2D getLimits() {
        return this.graph.getLimits();
    }

    public int setNumberSubDivisions() {
        return this.n;
    }

    public int getMethod() {
        return this.method;
    }

    void addUpperLowerShape() {
        double inf = this.getInfimum(this.xl, this.xr);
        int pinf = this.scene2d.yToPixel(inf);
        double sup = this.getSupremum(this.xl, this.xr);
        int psup = this.scene2d.yToPixel(sup);
        MyPolygon p = new MyPolygon();
        MyPolygon p2 = new MyPolygon();
        if (inf >= 0.0) {
            p.addPoint(this.xPixLeft, this.yPix0);
            p.addPoint(this.xPixLeft, pinf);
            p.addPoint(this.xPixRight, pinf);
            p.addPoint(this.xPixRight, this.yPix0);
            p2.addPoint(this.xPixLeft, pinf);
            p2.addPoint(this.xPixLeft, psup);
            p2.addPoint(this.xPixRight, psup);
            p2.addPoint(this.xPixRight, pinf);
        }
        if (inf < 0.0 && sup <= 0.0) {
            p.addPoint(this.xPixLeft, this.yPix0);
            p.addPoint(this.xPixLeft, psup);
            p.addPoint(this.xPixRight, psup);
            p.addPoint(this.xPixRight, this.yPix0);
            p2.addPoint(this.xPixLeft, psup);
            p2.addPoint(this.xPixLeft, pinf);
            p2.addPoint(this.xPixRight, pinf);
            p2.addPoint(this.xPixRight, psup);
        }
        if (inf < 0.0 && sup > 0.0) {
            p2.addPoint(this.xPixLeft, this.yPix0);
            p2.addPoint(this.xPixLeft, psup);
            p2.addPoint(this.xPixRight, psup);
            p2.addPoint(this.xPixRight, this.yPix0);
            p2.addPoint(this.xPixLeft, this.yPix0);
            p2.addPoint(this.xPixLeft, pinf);
            p2.addPoint(this.xPixRight, pinf);
            p2.addPoint(this.xPixRight, this.yPix0);
        }
        p.fillcolor = this.color;
        p2.fillcolor = this.errorcolor;
        this.shapes.add(p2);
        this.shapes.add(p);
    }

    void addUpperSumShape() {
        double sup = this.getSupremum(this.xl, this.xr);
        int psup = this.scene2d.yToPixel(sup);
        MyPolygon p = new MyPolygon();
        p.addPoint(this.xPixLeft, this.yPix0);
        p.addPoint(this.xPixLeft, psup);
        p.addPoint(this.xPixRight, psup);
        p.addPoint(this.xPixRight, this.yPix0);
        p.fillcolor = sup < 0.0 && !this.negative_samecolor ? this.negativecolor : this.color;
        this.shapes.add(p);
    }

    void addLeftPointShape() {
        MyPolygon p = new MyPolygon();
        p.addPoint(this.xPixLeft, this.yPix0);
        p.addPoint(this.xPixLeft, this.yPixFLeft);
        p.addPoint(this.xPixRight, this.yPixFLeft);
        p.addPoint(this.xPixRight, this.yPix0);
        p.fillcolor = this.yPixFLeft > this.yPix0 && !this.negative_samecolor ? this.negativecolor : this.color;
        this.shapes.add(p);
    }

    void addRightPointShape() {
        MyPolygon p = new MyPolygon();
        p.addPoint(this.xPixLeft, this.yPix0);
        p.addPoint(this.xPixLeft, this.yPixFRight);
        p.addPoint(this.xPixRight, this.yPixFRight);
        p.addPoint(this.xPixRight, this.yPix0);
        p.fillcolor = this.yPixFRight > this.yPix0 && !this.negative_samecolor ? this.negativecolor : this.color;
        this.shapes.add(p);
    }

    void addLowerSumShape() {
        double inf = this.getInfimum(this.xl, this.xr);
        int pinf = this.scene2d.yToPixel(inf);
        MyPolygon p = new MyPolygon();
        p.addPoint(this.xPixLeft, this.yPix0);
        p.addPoint(this.xPixLeft, pinf);
        p.addPoint(this.xPixRight, pinf);
        p.addPoint(this.xPixRight, this.yPix0);
        p.fillcolor = inf < 0.0 && !this.negative_samecolor ? this.negativecolor : this.color;
        this.shapes.add(p);
    }

    void addRiemannShape() {
        double fpos = this.function.getValue(this.xm);
        System.out.println(this.xm);
        int yPixFmid = this.scene2d.yToPixel(fpos);
        MyPolygon p = new MyPolygon();
        p.addPoint(this.xPixLeft, this.yPix0);
        p.addPoint(this.xPixLeft, yPixFmid);
        p.addPoint(this.xPixRight, yPixFmid);
        p.addPoint(this.xPixRight, this.yPix0);
        p.fillcolor = yPixFmid > this.yPix0 && !this.negative_samecolor ? this.negativecolor : this.color;
        this.shapes.add(p);
    }

    void addMidPointShape() {
        double fmid = this.function.getValue((this.xl + this.xr) / 2.0);
        int yPixFmid = this.scene2d.yToPixel(fmid);
        MyPolygon p = new MyPolygon();
        p.addPoint(this.xPixLeft, this.yPix0);
        p.addPoint(this.xPixLeft, yPixFmid);
        p.addPoint(this.xPixRight, yPixFmid);
        p.addPoint(this.xPixRight, this.yPix0);
        p.fillcolor = yPixFmid > this.yPix0 && !this.negative_samecolor ? this.negativecolor : this.color;
        this.shapes.add(p);
    }

    void addTrapezoidShape() {
        if (this.negative_samecolor) {
            MyPolygon p = new MyPolygon();
            p.addPoint(this.xPixLeft, this.yPix0);
            p.addPoint(this.xPixLeft, this.yPixFLeft);
            p.addPoint(this.xPixRight, this.yPixFRight);
            p.addPoint(this.xPixRight, this.yPix0);
            p.fillcolor = this.color;
            this.shapes.add(p);
            return;
        }
        if (this.yPixFLeft > this.yPix0 && this.yPixFRight > this.yPix0) {
            MyPolygon p = new MyPolygon();
            p.addPoint(this.xPixLeft, this.yPix0);
            p.addPoint(this.xPixLeft, this.yPixFLeft);
            p.addPoint(this.xPixRight, this.yPixFRight);
            p.addPoint(this.xPixRight, this.yPix0);
            p.fillcolor = this.negativecolor;
            this.shapes.add(p);
            return;
        }
        if (this.yPixFLeft <= this.yPix0 && this.yPixFRight <= this.yPix0) {
            MyPolygon p = new MyPolygon();
            p.addPoint(this.xPixLeft, this.yPix0);
            p.addPoint(this.xPixLeft, this.yPixFLeft);
            p.addPoint(this.xPixRight, this.yPixFRight);
            p.addPoint(this.xPixRight, this.yPix0);
            p.fillcolor = this.color;
            this.shapes.add(p);
            return;
        }
        int xs = (this.xPixRight * this.yPixFLeft - this.xPixLeft * this.yPixFRight + this.yPix0 * this.xPixLeft - this.yPix0 * this.xPixRight) / (this.yPixFLeft - this.yPixFRight);
        MyPolygon p1 = new MyPolygon();
        p1.addPoint(this.xPixLeft, this.yPix0);
        p1.addPoint(this.xPixLeft, this.yPixFLeft);
        p1.addPoint(xs, this.yPix0);
        p1.fillcolor = this.yPixFLeft > this.yPix0 ? this.negativecolor : this.color;
        this.shapes.add(p1);
        MyPolygon p2 = new MyPolygon();
        p2.addPoint(this.xPixRight, this.yPix0);
        p2.addPoint(this.xPixRight, this.yPixFRight);
        p2.addPoint(xs, this.yPix0);
        p2.fillcolor = this.yPixFRight > this.yPix0 ? this.negativecolor : this.color;
        this.shapes.add(p2);
    }

    private double getSupremum(double a, double b) {
        double length = b - a;
        int nn = Math.max(10, this.panel.getWidth());
        double part = length / this.scene2d.getXRange();
        int l = (int)(part * (double)nn * 5.0);
        if (l < 2) {
            return this.function.getValue(a);
        }
        IntervalIterator it = new IntervalIterator(a, b, l);
        double sup = Double.NEGATIVE_INFINITY;
        while (it.hasNext()) {
            double f = this.function.getValue(it.nextdouble());
            if (!(f > sup)) continue;
            sup = f;
        }
        return sup;
    }

    private double getInfimum(double a, double b) {
        double length = b - a;
        int nn = Math.max(10, this.panel.getWidth());
        double part = length / this.scene2d.getXRange();
        int l = (int)(part * (double)nn * 5.0);
        if (l < 2) {
            return this.function.getValue(a);
        }
        IntervalIterator it = new IntervalIterator(a, b, l);
        double inf = Double.POSITIVE_INFINITY;
        while (it.hasNext()) {
            double f = this.function.getValue(it.nextdouble());
            if (!(f < inf)) continue;
            inf = f;
        }
        return inf;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSum2() {
        return this.sum2;
    }

    private void computesum() {
        this.sum = 0.0;
        this.sum2 = 0.0;
        Iterator it = this.points.iterator();
        DragablePoint2D last = null;
        while (it.hasNext()) {
            DragablePoint2D mathpoint = (DragablePoint2D)it.next();
            if (last != null) {
                this.xleft = last.getX();
                this.xright = mathpoint.getX();
                this.h = Math.abs(this.xleft - this.xright);
                switch (this.method) {
                    case 1: {
                        this.addLowerSum();
                        break;
                    }
                    case 0: {
                        this.addUpperSum();
                        break;
                    }
                    case 3: {
                        this.addMidPointSum();
                        break;
                    }
                    case 4: {
                        this.addTrapezoidSum();
                        break;
                    }
                    case 5: {
                        this.addUpperLowerSum();
                        break;
                    }
                    case 7: {
                        this.addRightPointSum();
                        break;
                    }
                    case 6: {
                        this.addLeftPointSum();
                    }
                }
            }
            last = mathpoint;
        }
    }

    void addUpperSum() {
        double sup = this.getSupremum(this.xleft, this.xright);
        this.sum += this.h * sup;
    }

    void addLeftPointSum() {
        double fleft = this.function.getValue(this.xleft);
        this.sum += fleft * this.h;
    }

    void addRightPointSum() {
        double fright = this.function.getValue(this.xright);
        this.sum += fright * this.h;
    }

    void addLowerSum() {
        double inf = this.getInfimum(this.xleft, this.xright);
        this.sum += this.h * inf;
    }

    void addMidPointSum() {
        double fmid = this.function.getValue((this.xleft + this.xright) / 2.0);
        this.sum += fmid * this.h;
    }

    void addUpperLowerSum() {
        double sup = this.getSupremum(this.xleft, this.xright);
        this.sum += this.h * sup;
        double inf = this.getInfimum(this.xleft, this.xright);
        this.sum2 += this.h * inf;
    }

    void addTrapezoidSum() {
        double fright = this.function.getValue(this.xright);
        double fleft = this.function.getValue(this.xleft);
        this.sum += this.h * (fleft + fright) / 2.0;
    }

    public Function1D getFunction() {
        return this.function;
    }

    public Interval getInterval() {
        return (Interval)this.interval.clone();
    }

    public void enableSameColor(boolean b) {
        this.negative_samecolor = b;
    }

    public boolean isEnabledSameColor() {
        return this.negative_samecolor;
    }

    class IntervalPoint
    extends DragablePoint2D {
        public int x_pix;
        public int y_pix;
        IntervalPoint left;
        IntervalPoint right;

        public IntervalPoint(double x) {
            super(x, 0.0);
            this.left = null;
            this.right = null;
        }

        @Override
        public void drag(MouseEvent ev) {
            double t = this.scene2d.pixelToX(ev.getX());
            if (this.left == null && t < Integration2DVisualisation.this.interval.a) {
                return;
            }
            if (this.right == null && t > Integration2DVisualisation.this.interval.b) {
                return;
            }
            if (this.left != null && t <= this.left.x) {
                return;
            }
            if (this.right != null && t >= this.right.x) {
                return;
            }
            this.x = t;
        }
    }

    class MyPolygon
    extends Polygon {
        Color fillcolor;

        MyPolygon() {
        }
    }
}

