/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.schiessVerfahren2d;

import Jama.Matrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import uibk.applets.schiessVerfahren2d.AppletSchiessVerfahren2d;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathArrow2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.CheckBox;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public abstract class Verfahren
extends MPanel
implements ActionListener,
Runnable {
    protected final AppletSchiessVerfahren2d main;
    protected final Verfahren verfahren;
    public static final int DGL_EINFACH = 1;
    public static final int DGL_SYSTEM = 2;
    public static final int DGL_FREIERRAND = 3;
    public static final int DGL_PERIODE = 4;
    protected MathPoint2D[] endPunkt = new MathPoint2D[2];
    protected MathPoint2D[] startPunkt = new MathPoint2D[2];
    protected MathArrow2D[] startRichtung = new MathArrow2D[2];
    protected double yBs = 0.0;
    protected double T = 0.0;
    protected double X0 = 0.0;
    protected double tol = 1.0E-8;
    protected CheckBox lambdaSt;
    protected DoubleTextField textTol;
    private DoubleTextField textya;
    private DoubleTextField textyas;
    private DoubleTextField textua;
    private DoubleTextField textuas;
    protected Matrix y = null;
    protected boolean firstCall = true;
    protected Vector sol = null;
    private MPanel panelStartwerte;
    protected int artDiffGl = 1;
    public final int RADIUS = 10;
    private boolean[] mouseFlag = new boolean[2];
    private boolean[] mouseKlick = new boolean[2];
    private double lambda = 1.0;
    private Matrix deltay = null;
    private Graph2D[] oldGraph = new Graph2D[2];
    JButton jButtonAbbruch;
    private final int SCHUSS = 1;
    private final int ITERATION = 2;
    private final int LOESEN = 3;
    private int action = 0;
    protected ParsedFunction f = null;
    private boolean abbruchFlag = false;

    Verfahren(AppletSchiessVerfahren2d main) {
        this.main = main;
        this.verfahren = this;
        int i = 0;
        while (i < 2) {
            this.startRichtung[i] = new MathArrow2D();
            main.mathpanel2D.add(this.startRichtung[i]);
            this.startRichtung[i].setStroke(new BasicStroke(2.5f));
            this.startRichtung[i].setColor(AppletSchiessVerfahren2d.COLOR_F[i]);
            this.endPunkt[i] = new MathPoint2D();
            main.mathpanel2D.add(this.endPunkt[i]);
            this.endPunkt[i].setRadius(5);
            this.endPunkt[i].setColor(AppletSchiessVerfahren2d.COLOR_F[i]);
            this.startPunkt[i] = new MathPoint2D();
            main.mathpanel2D.add(this.startPunkt[i]);
            this.startPunkt[i].setRadius(5);
            this.startPunkt[i].setColor(AppletSchiessVerfahren2d.COLOR_F[i]);
            ++i;
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createPanelOptionen());
        this.panelStartwerte = this.createPanelStartwerte();
        this.add(this.panelStartwerte);
        this.add(this.createPanelSteuerung());
        this.neu();
        main.mathpanel2D.addMouseMotionListener(new MyMouseMotionListener());
        main.mathpanel2D.addMouseListener(new MyMouseListener());
    }

    public void setPunkte(double x0, double[] y, double x1, double y1, double y1s) {
        if (this.artDiffGl == 3) {
            this.yBs = y1s;
        }
        if (this.artDiffGl == 4) {
            this.X0 = x0;
            this.T = x1;
            this.startPunkt[0].setCoordinates(y[0], y[1]);
            this.endPunkt[0].setCoordinates(y[0], y[1]);
        } else {
            this.startPunkt[0].setCoordinates(x0, y[0]);
            this.endPunkt[0].setCoordinates(x1, y1);
        }
        this.setSceneTangente(null);
    }

    public void setPunkte(double x0, double[] y, double[] u, double x1, double y1, double u1) {
        this.setPunkte(x0, y, x1, y1, 0.0);
        this.endPunkt[1].setCoordinates(x1, u1);
        this.startPunkt[1].setCoordinates(x0, u[0]);
        this.setSceneTangente(null);
    }

    private void tangente(double x, double f_x, double steig, MathArrow2D tangente) {
        Scene2D scene2d = this.main.mathpanel2D.getScene2d();
        double eps = scene2d.getXRange() > scene2d.getYRange() ? scene2d.getXRange() : scene2d.getYRange();
        double xt = 1.0 / this.norm(1.0, steig) * eps;
        double yt = steig / this.norm(1.0, steig) * eps;
        int xt1 = scene2d.xToPixel(x + xt);
        int yt1 = scene2d.yToPixel(f_x + yt);
        int xt2 = scene2d.xToPixel(x);
        int yt2 = scene2d.yToPixel(f_x);
        double lP = this.norm(xt1 - xt2, yt1 - yt2);
        xt = xt / lP * (double)scene2d.getCoordinatePixelRectangle().width / 5.0;
        yt = yt / lP * (double)scene2d.getCoordinatePixelRectangle().width / 5.0;
        tangente.setBase(new Punkt2D(x, f_x));
        tangente.setHead(new Punkt2D(x + xt, f_x + yt));
    }

    private double norm(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    private void getTol() throws Exception {
        this.tol = this.textTol.getValue();
        this.main.odeSolver.setTOL(this.tol);
    }

    abstract MPanel createPanelSet();

    private MPanel createPanelOptionen() {
        TitledPanel panelOption = new TitledPanel(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.1"));
        panelOption.setLayout(new BoxLayout(panelOption, 1));
        panelOption.setMaximumSize(new Dimension(1000, 80));
        this.lambdaSt = new CheckBox(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.9"));
        this.lambdaSt.setSelected(false);
        this.lambdaSt.addActionListener(this);
        this.lambdaSt.setToolTipText(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.10"));
        panelOption.add(this.createPanelSet());
        panelOption.add(this.lambdaSt);
        return panelOption;
    }

    private MPanel createPanelStartwerte() {
        TitledPanel panelOption = new TitledPanel(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.20"));
        panelOption.setLayout(new GridBagLayout());
        panelOption.setMaximumSize(new Dimension(1000, 80));
        this.textya = new DoubleTextField(10, null, null, null, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.21"));
        this.textya.setToolTipText(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.22"));
        this.textya.setEditable(false);
        this.textyas = new DoubleTextField(10, null, null, null, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.24"));
        this.textyas.setToolTipText(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.25"));
        this.textyas.setEditable(false);
        this.textua = new DoubleTextField(10, null, null, null, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.27"));
        this.textua.setToolTipText(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.28"));
        this.textua.setEditable(false);
        this.textuas = new DoubleTextField(10, null, null, null, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.30"));
        this.textuas.setToolTipText(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.31"));
        this.textuas.setEditable(false);
        panelOption.add((Component)new JLabel(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.23")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelOption.add((Component)this.textya, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelOption.add((Component)new JLabel(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.26")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelOption.add((Component)this.textyas, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelOption.add((Component)new JLabel(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.29")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelOption.add((Component)this.textua, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelOption.add((Component)new JLabel(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.32")), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelOption.add((Component)this.textuas, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        return panelOption;
    }

    private MPanel createPanelSteuerung() {
        TitledPanel panelSteuerung = new TitledPanel(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.5"));
        panelSteuerung.setLayout(new GridLayout(2, 2, 30, 5));
        panelSteuerung.setMaximumSize(new Dimension(1000, 1000));
        JButton jButtonCalc = new JButton(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.6"));
        jButtonCalc.setActionCommand("schuss");
        jButtonCalc.addActionListener(this);
        JButton jButtonItar = new JButton(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.7"));
        jButtonItar.setActionCommand("itaration");
        jButtonItar.addActionListener(this);
        JButton jButtonLoesen = new JButton(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.8"));
        jButtonLoesen.setActionCommand("loesen");
        jButtonLoesen.addActionListener(this);
        this.jButtonAbbruch = new JButton(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.11"));
        this.jButtonAbbruch.setActionCommand("abbruch");
        this.jButtonAbbruch.addActionListener(this);
        panelSteuerung.add(jButtonCalc);
        panelSteuerung.add(jButtonItar);
        panelSteuerung.add(jButtonLoesen);
        panelSteuerung.add(this.jButtonAbbruch);
        return panelSteuerung;
    }

    public void neu() {
        int i = 0;
        while (i < 2) {
            this.endPunkt[i].setVisible(false);
            this.startPunkt[i].setVisible(false);
            this.startRichtung[i].setVisible(false);
            this.endPunkt[i].setCoordinates(1.0, 1.0);
            this.startPunkt[i].setCoordinates(-1.0, -1.0);
            this.startRichtung[i].setBase(new Punkt2D(-1.0, -1.0));
            this.startRichtung[i].setHead(new Punkt2D(-1.0, -1.0));
            ++i;
        }
        this.main.mathpanel2D.getScene2d().setLimits(-1.0, 1.0, -1.0, 1.0);
        this.firstCall = true;
        this.sol = null;
        this.lambda = 1.0;
        this.textya.setText("");
        this.textyas.setText("");
        this.textua.setText("");
        this.textuas.setText("");
        this.mouseFlag[0] = false;
        this.mouseFlag[1] = false;
        this.mouseKlick[0] = false;
        this.mouseKlick[1] = false;
        this.main.mathpanel2D.getScene2d().enableRound(true);
        this.main.odeSolver.setStepsDense(1000);
        this.action = 0;
        this.abbruchFlag = false;
    }

    public void addGraph(Vector sol) throws Exception {
        if (sol == null || sol.size() < 1) {
            return;
        }
        Graph2D[] graph = new Graph2D[2];
        CoordinateRect2D[] limits = new CoordinateRect2D[2];
        int zaehler = this.artDiffGl;
        if (this.artDiffGl == 3 || this.artDiffGl == 4) {
            zaehler = 1;
        }
        int i = 0;
        while (i < zaehler) {
            if (this.oldGraph[i] != null) {
                this.oldGraph[i].setColor(Color.lightGray);
            }
            graph[i] = new Graph2D();
            this.oldGraph[i] = graph[i];
            if (sol.size() > 1) {
                double[] p = null;
                int j = 0;
                while (j < sol.size()) {
                    if (sol.elementAt(j) != null) {
                        p = (double[])sol.elementAt(j);
                        if (this.artDiffGl == 3) {
                            graph[i].addPoint(this.startPunkt[0].getX() + p[0] * p[3], p[2 * i + 1]);
                        } else if (this.artDiffGl == 4) {
                            graph[i].addPoint(p[1], p[2]);
                        } else {
                            graph[i].addPoint(p[0], p[2 * i + 1]);
                        }
                    } else {
                        graph[i].addPoint(null);
                    }
                    ++j;
                }
                this.main.graphflow.addGraph(graph[i]);
                this.main.mathpanel2D.getScene2d().enableRound(true);
                limits[i] = graph[i].getLimits();
                this.getTol();
                double tolPlot = this.tol;
                boolean treffer = false;
                if (this.artDiffGl == 4) {
                    if (p[1] + tolPlot > this.endPunkt[0].getX() && p[1] - tolPlot < this.endPunkt[0].getX() && p[2] + tolPlot > this.endPunkt[0].getY() && p[2] - tolPlot < this.endPunkt[0].getY()) {
                        treffer = true;
                    }
                } else if (p[1] + tolPlot > this.endPunkt[0].getY() && p[1] - tolPlot < this.endPunkt[0].getY()) {
                    treffer = true;
                }
                if (treffer) {
                    graph[i].setColor(Color.red);
                    this.main.mathpanel2D.report(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.15"));
                    if (!(this.artDiffGl != 3 || p[2] + tolPlot > this.yBs && p[2] - tolPlot < this.yBs)) {
                        graph[i].setColor(Color.black);
                        this.main.mathpanel2D.report(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.17"));
                    }
                } else {
                    graph[i].setColor(Color.black);
                    this.main.mathpanel2D.report(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.16"));
                }
            } else {
                limits = null;
            }
            ++i;
        }
        this.setSceneTangente(limits);
    }

    private void setSceneTangente(CoordinateRect2D[] limits) {
        this.setScene(limits, false);
        if (this.artDiffGl != 4) {
            this.tangente(this.startPunkt[0].getX(), this.y.get(0, 0), this.y.get(1, 0), this.startRichtung[0]);
            if (this.artDiffGl == 2) {
                this.tangente(this.startPunkt[0].getX(), this.y.get(2, 0), this.y.get(3, 0), this.startRichtung[1]);
            }
        }
        this.setScene(limits, true);
    }

    public void setScene(CoordinateRect2D[] limits, boolean checkTangente) {
        if (this.y != null) {
            double xmin = this.startPunkt[0].getX();
            double xmax = this.endPunkt[0].getX();
            double ymin = Double.MAX_VALUE;
            double ymax = -1.7976931348623157E308;
            double[] pY = new double[6];
            pY[0] = this.startPunkt[0].getY();
            pY[1] = this.endPunkt[0].getY();
            if (checkTangente) {
                pY[2] = this.startRichtung[0].getHead().y;
                pY[3] = this.startRichtung[1].getHead().y;
            } else {
                pY[2] = this.endPunkt[0].getY();
                pY[3] = this.endPunkt[1].getY();
            }
            pY[4] = this.endPunkt[1].getY();
            pY[5] = this.startPunkt[1].getY();
            if (limits != null) {
                ymin = limits[0].ymin;
                ymax = limits[0].ymax;
                if (this.artDiffGl == 2) {
                    if (ymin > limits[1].ymin) {
                        ymin = limits[1].ymin;
                    }
                    if (ymax < limits[1].ymax) {
                        ymax = limits[1].ymax;
                    }
                }
                if (this.artDiffGl == 4) {
                    xmin = limits[0].xmin;
                    xmax = limits[0].xmax;
                }
            }
            double anz = 3.0;
            if (this.artDiffGl == 2) {
                anz = 6.0;
            }
            if (this.artDiffGl == 4) {
                anz = 1.0;
            }
            int i = 0;
            while ((double)i < anz) {
                if (pY[i] < ymin) {
                    ymin = pY[i];
                }
                if (pY[i] > ymax) {
                    ymax = pY[i];
                }
                ++i;
            }
            if (ymax - ymin < 0.01) {
                double mitte = ymin + (ymax - ymin) / 2.0;
                ymax = mitte + 0.005;
                ymin = mitte - 0.005;
            }
            if (xmax - xmin < 0.01) {
                xmax += 0.01;
                xmin -= 0.01;
            }
            this.main.mathpanel2D.getScene2d().setLimits(xmin, xmax, ymin, ymax);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("schuss")) {
            this.action = 1;
            this.start();
        }
        if (ev.getActionCommand().equals("itaration")) {
            this.action = 2;
            this.start();
        }
        if (ev.getActionCommand().equals("loesen")) {
            this.action = 3;
            this.start();
        }
        if (ev.getActionCommand().equals("abbruch")) {
            this.abbruchFlag = true;
        }
    }

    private void schuss() throws Exception {
        this.main.mathpanel2D.getScene2d().enableRound(true);
        this.datenLesen(this.y);
        this.setInitials(this.y, null);
        this.y = this.solve(this.y);
        this.addGraph(this.sol);
        this.firstCall = false;
    }

    protected abstract Matrix solve(Matrix var1) throws Exception;

    protected void setInitials(Matrix m, Interval i) {
        double[] y0;
        double[] initials = null;
        if (this.artDiffGl == 1) {
            initials = new double[]{i == null ? this.startPunkt[0].getX() : i.a, m.get(0, 0), m.get(1, 0), m.get(0, 0) + this.main.DELTA, m.get(1, 0), m.get(0, 0), m.get(1, 0) + this.main.DELTA};
            y0 = new double[]{m.get(0, 0), m.get(1, 0)};
            if (i == null) {
                this.setPunkte(initials[0], y0, this.endPunkt[0].getX(), this.endPunkt[0].getY(), 0.0);
            }
        }
        if (this.artDiffGl == 2) {
            initials = new double[]{i == null ? this.startPunkt[0].getX() : i.a, m.get(0, 0), m.get(1, 0), m.get(2, 0), m.get(3, 0), m.get(0, 0) + this.main.DELTA, m.get(1, 0), m.get(2, 0), m.get(3, 0), m.get(0, 0), m.get(1, 0) + this.main.DELTA, m.get(2, 0), m.get(3, 0), m.get(0, 0), m.get(1, 0), m.get(2, 0) + this.main.DELTA, m.get(3, 0), m.get(0, 0), m.get(1, 0), m.get(2, 0), m.get(3, 0) + this.main.DELTA};
            y0 = new double[]{m.get(0, 0), m.get(1, 0)};
            double[] u0 = new double[]{m.get(2, 0), m.get(3, 0)};
            if (i == null) {
                this.setPunkte(initials[0], y0, u0, this.endPunkt[0].getX(), this.endPunkt[0].getY(), this.endPunkt[1].getY());
            }
        }
        if (this.artDiffGl == 3) {
            initials = new double[]{i == null ? 0.0 : i.a, m.get(0, 0), m.get(1, 0), m.get(2, 0), m.get(0, 0) + this.main.DELTA, m.get(1, 0), m.get(2, 0), m.get(0, 0), m.get(1, 0) + this.main.DELTA, m.get(2, 0), m.get(0, 0), m.get(1, 0), m.get(2, 0) + this.main.DELTA};
            y0 = new double[]{m.get(0, 0), m.get(1, 0)};
            if (i == null) {
                this.setPunkte(this.startPunkt[0].getX(), y0, this.endPunkt[0].getX(), this.endPunkt[0].getY(), this.yBs);
            }
            this.main.odeSolver.setIntegrationInvervall(new Interval(0.0, 1.0));
        }
        if (this.artDiffGl == 4) {
            initials = new double[]{this.X0, m.get(0, 0), m.get(1, 0), m.get(0, 0) + this.main.DELTA, m.get(1, 0), m.get(0, 0), m.get(1, 0) + this.main.DELTA};
            y0 = new double[]{m.get(0, 0), m.get(1, 0)};
            if (i == null) {
                this.setPunkte(this.X0, y0, this.T, 0.0, 0.0);
            }
            this.main.odeSolver.setIntegrationInvervall(new Interval(this.X0, this.T));
        }
        this.main.odeSolver.setInitialCondition(initials[0], initials);
        if (i != null) {
            this.main.odeSolver.setIntegrationInvervall(i);
        }
    }

    private double iteration() throws Exception {
        this.main.mathpanel2D.getScene2d().enableRound(true);
        this.main.report.iteration(true);
        if (this.firstCall) {
            this.schuss();
        }
        Matrix Df = this.Df();
        this.deltay = this.artDiffGl == 4 ? Df.solve(this.equ(this.y)) : Df.solve(this.equ(this.y)).times(-1.0);
        if (this.lambdaSt.isSelected()) {
            Matrix y_lambda = this.y.plus(this.deltay.times(this.lambda));
            this.setInitials(y_lambda, null);
            this.solve(y_lambda);
            Matrix deltay_lambda = null;
            deltay_lambda = this.artDiffGl == 4 ? Df.solve(this.equ(y_lambda)) : Df.solve(this.equ(y_lambda)).times(-1.0);
            double g_lambda = deltay_lambda.norm2();
            double g_0 = this.deltay.norm2();
            if (g_lambda > g_0) {
                while (g_lambda > g_0) {
                    this.lambda /= 2.0;
                    y_lambda = this.y.plus(this.deltay.times(this.lambda));
                    this.setInitials(y_lambda, null);
                    this.solve(y_lambda);
                    deltay_lambda = this.artDiffGl == 4 ? Df.solve(this.equ(y_lambda)) : Df.solve(this.equ(y_lambda)).times(-1.0);
                    g_lambda = deltay_lambda.norm2();
                    if (!(this.lambda < 1.0E-5)) continue;
                    throw new Exception(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.13"));
                }
            } else if (this.lambda < 1.0) {
                while (g_lambda < g_0 && this.lambda <= 2.0) {
                    g_0 = g_lambda;
                    this.lambda *= 2.0;
                    y_lambda = this.y.plus(this.deltay.times(this.lambda));
                    this.setInitials(y_lambda, null);
                    this.solve(y_lambda);
                    deltay_lambda = this.artDiffGl == 4 ? Df.solve(this.equ(y_lambda)) : Df.solve(this.equ(y_lambda)).times(-1.0);
                    g_lambda = deltay_lambda.norm2();
                }
                this.lambda = Math.min(1.0, this.lambda / 2.0);
            }
            this.y = this.y.plus(this.deltay.times(this.lambda));
            this.main.report.lambda(this.lambda);
        } else {
            this.y = this.y.plus(this.deltay);
        }
        this.datenSetzen(this.y);
        this.schuss();
        if (this.artDiffGl == 1) {
            this.main.report.anstieg(new Double(this.y.get(1, 0)), null);
        }
        if (this.artDiffGl == 2) {
            this.main.report.anstieg(new Double(this.y.get(1, 0)), new Double(this.y.get(3, 0)));
        }
        if (this.artDiffGl == 3) {
            this.main.report.anstieg(new Double(this.y.get(1, 0)), null);
            this.main.report.intervalEnde(new Double(this.endPunkt[0].getX()));
        }
        if (this.artDiffGl == 4) {
            this.main.report.periode(this.y.get(0, 0), this.y.get(1, 0), this.y.get(2, 0) - this.X0);
        }
        this.main.report.fehlerNewton(this.deltay.norm2());
        return this.deltay.norm2();
    }

    protected abstract Matrix equ(Matrix var1) throws Exception;

    protected abstract Matrix Df() throws Exception;

    private void loesen() throws Exception {
        int k = 0;
        while (k++ < this.main.MAX_STEPS && this.iteration() > this.tol) {
        }
        if (k >= this.main.MAX_STEPS) {
            throw new Exception(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.13"));
        }
        this.main.mathpanel2D.report(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.14"));
    }

    private void datenSetzen(Matrix m) throws Exception {
        Double dya = null;
        if (this.artDiffGl == 3) {
            double b = m.get(2, 0) + this.startPunkt[0].getX();
            if (b < this.startPunkt[0].getX()) {
                throw new Exception(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.41"));
            }
            this.endPunkt[0].setX(b);
        }
        if (this.artDiffGl == 4) {
            this.T = m.get(2, 0);
            dya = new Double(m.get(0, 0));
            if (this.T < this.X0) {
                throw new Exception(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.42"));
            }
        } else {
            dya = new Double(this.startPunkt[0].getY());
        }
        Double dyas = new Double(m.get(1, 0));
        this.textya.setText(dya.toString());
        this.textyas.setText(dyas.toString());
        if (this.artDiffGl == 2) {
            Double dua = new Double(this.startPunkt[1].getY());
            Double duas = new Double(m.get(3, 0));
            this.textua.setText(dua.toString());
            this.textuas.setText(duas.toString());
        }
    }

    public void datenUebernehmen(double[] y0) throws Exception {
        Double d = null;
        d = new Double(y0[0]);
        this.textya.setText(d.toString());
        d = new Double(y0[1]);
        this.textyas.setText(d.toString());
        this.main.graphflow.clear();
        this.firstCall = true;
        this.lambda = 1.0;
        this.datenLesen(this.y);
    }

    public void datenUebernehmen(double[] y, double[] u) throws Exception {
        Double d = null;
        d = new Double(u[0]);
        this.textua.setText(d.toString());
        d = new Double(u[1]);
        this.textuas.setText(d.toString());
        this.datenUebernehmen(y);
    }

    protected void datenLesen(Matrix y) throws Exception {
        String strfunc = this.textya.getText();
        y.set(0, 0, Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.21"), null, null, null));
        strfunc = this.textyas.getText();
        y.set(1, 0, Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.24"), null, null, null));
        if (this.artDiffGl == 2) {
            strfunc = this.textua.getText();
            y.set(2, 0, Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.27"), null, null, null));
            strfunc = this.textuas.getText();
            y.set(3, 0, Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.30"), null, null, null));
        }
        if (this.artDiffGl == 3) {
            y.set(2, 0, this.endPunkt[0].getX() - this.startPunkt[0].getX());
        }
        if (this.artDiffGl == 4) {
            y.set(2, 0, this.T);
        }
    }

    protected abstract void tangenteVeraendert();

    public void setDglTyp(int typ) {
        this.artDiffGl = typ;
        if (typ == 1) {
            this.y = new Matrix(2, 1);
            this.main.axes.setCaptionXAxis("t");
            this.main.axes.setCaptionYAxis("y(t)");
        }
        if (typ == 2) {
            this.y = new Matrix(4, 1);
            this.main.axes.setCaptionXAxis("t");
            this.main.axes.setCaptionYAxis("y(t),u(t)");
        }
        if (typ == 3) {
            this.y = new Matrix(3, 1);
            this.main.axes.setCaptionXAxis("t");
            this.main.axes.setCaptionYAxis("y(t)");
        }
        if (typ == 4) {
            this.y = new Matrix(3, 1);
            this.main.axes.setCaptionXAxis("y(t)");
            this.main.axes.setCaptionYAxis("z(t)");
        }
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        int zaehler = this.artDiffGl;
        if (this.artDiffGl == 3 || this.artDiffGl == 4) {
            zaehler = 1;
        }
        int i = 0;
        while (i < zaehler) {
            this.startRichtung[i].setVisible(b);
            this.endPunkt[i].setVisible(b);
            this.startPunkt[i].setVisible(b);
            ++i;
        }
        if (this.artDiffGl == 4) {
            this.startRichtung[0].setVisible(false);
        }
        this.jButtonAbbruch.setEnabled(false);
    }

    public void run() {
        Color br = this.jButtonAbbruch.getBackground();
        this.setEnabled(false);
        this.jButtonAbbruch.setEnabled(true);
        this.jButtonAbbruch.setBackground(Color.red);
        try {
            if (this.action == 1) {
                this.schuss();
                Double AbYb = null;
                Double AbUb = null;
                double[] p = (double[])this.sol.lastElement();
                double yb = this.endPunkt[0].getPunkt2D().y;
                AbYb = new Double(Math.abs(p[1] - yb));
                if (this.artDiffGl == 4) {
                    this.main.report.abstand(Math.abs(p[1] - this.startPunkt[0].getX()), Math.abs(p[2] - this.startPunkt[0].getY()));
                } else {
                    this.main.report.abstand(AbYb, AbUb);
                }
                if (this.artDiffGl == 2) {
                    double ub = this.endPunkt[1].getPunkt2D().y;
                    AbUb = new Double(Math.abs(p[3] - ub));
                }
                if (this.artDiffGl == 3) {
                    double AbYbs = Math.abs(p[2] - this.yBs);
                    this.main.report.abstand(new Double(AbYbs));
                }
            }
            if (this.action == 2) {
                this.iteration();
            }
            if (this.action == 3) {
                this.loesen();
            }
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(e);
            if (this.oldGraph[0] != null) {
                CoordinateRect2D[] limits = new CoordinateRect2D[]{this.oldGraph[0].getLimits(), this.artDiffGl == 2 && this.oldGraph[1] != null ? this.oldGraph[1].getLimits() : this.oldGraph[0].getLimits()};
                this.setSceneTangente(limits);
            } else {
                this.setSceneTangente(null);
            }
            this.main.report.error(e);
        }
        this.jButtonAbbruch.setBackground(br);
        this.setEnabled(true);
        this.main.mathpanel2D.repaint();
    }

    public void start() {
        Thread t1 = new Thread((Runnable)this, "Calc");
        t1.start();
    }

    protected void checkAbbruch() throws Exception {
        if (this.abbruchFlag) {
            this.abbruchFlag = false;
            throw new Exception(Messages.getString("uibk.applets.schiessVerfahren2d.messages", "Verfahren.11"));
        }
    }

    public void setFunktion(ParsedFunction f) {
        this.f = f;
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent ev) {
            if (Verfahren.this.verfahren.isEnabled() && Verfahren.this.artDiffGl != 4) {
                int zaehler = Verfahren.this.artDiffGl == 3 ? 1 : Verfahren.this.artDiffGl;
                int i = 0;
                while (i < zaehler) {
                    if (Verfahren.this.mouseFlag[i]) {
                        if (Verfahren.this.mouseKlick[i]) {
                            ((Verfahren)Verfahren.this).mouseKlick[i] = false;
                            Verfahren.this.startRichtung[i].setColor(AppletSchiessVerfahren2d.COLOR_F[i]);
                            Verfahren.this.main.mathpanel2D.repaint();
                        } else {
                            ((Verfahren)Verfahren.this).mouseKlick[i] = true;
                            Verfahren.this.startRichtung[i].setColor(Color.red);
                            Verfahren.this.main.mathpanel2D.repaint();
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent ev) {
            if (Verfahren.this.verfahren.isEnabled() && Verfahren.this.artDiffGl != 4) {
                int xm = ev.getX();
                int ym = ev.getY();
                int zaehler = Verfahren.this.artDiffGl == 3 ? 1 : Verfahren.this.artDiffGl;
                int i = 0;
                while (i < zaehler) {
                    int xp = Verfahren.this.main.mathpanel2D.getScene2d().xToPixel(Verfahren.this.startRichtung[i].getHead().x);
                    int yp = Verfahren.this.main.mathpanel2D.getScene2d().yToPixel(Verfahren.this.startRichtung[i].getHead().y);
                    if (!Verfahren.this.mouseFlag[(i + 1) % 2] && ((xm - xp) * (xm - xp) + (ym - yp) * (ym - yp) < 100 || Verfahren.this.mouseKlick[i])) {
                        Cursor c = new Cursor(12);
                        Verfahren.this.main.setCursor(c);
                        ((Verfahren)Verfahren.this).mouseFlag[i] = true;
                        if (Verfahren.this.mouseKlick[i]) {
                            Scene2D scene2d = Verfahren.this.main.mathpanel2D.getScene2d();
                            double mx = scene2d.pixelToX(ev.getX());
                            double my = scene2d.pixelToY(ev.getY());
                            if (mx < Verfahren.this.startRichtung[i].getBase().x) {
                                mx = Verfahren.this.startRichtung[i].getBase().x;
                            }
                            Verfahren.this.startRichtung[i].setHead(new Punkt2D(mx, my));
                            double dx = Verfahren.this.startRichtung[i].getHead().x - Verfahren.this.startRichtung[i].getBase().x;
                            double dy = Verfahren.this.startRichtung[i].getHead().y - Verfahren.this.startRichtung[i].getBase().y;
                            Double k = new Double(dy / dx);
                            if (i == 0) {
                                Verfahren.this.textyas.setText(k.toString());
                            } else {
                                Verfahren.this.textuas.setText(k.toString());
                            }
                            Verfahren.this.tangenteVeraendert();
                            Verfahren.this.main.mathpanel2D.repaint();
                        }
                    } else {
                        ((Verfahren)Verfahren.this).mouseFlag[i] = false;
                    }
                    ++i;
                }
                if (!Verfahren.this.mouseFlag[0] && !Verfahren.this.mouseFlag[1]) {
                    Cursor c = new Cursor(0);
                    Verfahren.this.main.setCursor(c);
                }
            }
        }
    }
}

