/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.list.lincv;

import cern.colt.matrix.DoubleMatrix2D;
import umontreal.iro.lecuyer.stat.FunctionOfMultipleMeansTally;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.stat.list.lincv.ListOfTalliesWithCV;
import umontreal.iro.lecuyer.util.MultivariateFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionOfMultipleMeansTallyWithCV
extends FunctionOfMultipleMeansTally {
    private MultivariateFunction funcNoCV;
    private double[] beta;

    public FunctionOfMultipleMeansTallyWithCV(MultivariateFunction multivariateFunction, int n, int n2) {
        super((MultivariateFunction)new LinCVFunction(n + n2), ListOfTalliesWithCV.createWithTally(n, n2));
        this.funcNoCV = multivariateFunction;
        this.beta = new double[n2];
        ((LinCVFunction)this.getFunction()).initFunctionOfMultipleMeansTallyWithCV(this);
    }

    public FunctionOfMultipleMeansTallyWithCV(MultivariateFunction multivariateFunction, ListOfTalliesWithCV<Tally> listOfTalliesWithCV) {
        super((MultivariateFunction)new LinCVFunction(listOfTalliesWithCV.size()), listOfTalliesWithCV);
        this.funcNoCV = multivariateFunction;
        this.beta = new double[listOfTalliesWithCV.getNumControlVariables()];
        ((LinCVFunction)this.getFunction()).initFunctionOfMultipleMeansTallyWithCV(this);
    }

    public MultivariateFunction getFunctionWithoutCV() {
        return this.funcNoCV;
    }

    public int getNumControlVariables() {
        return this.beta.length;
    }

    public int getDimensionWithoutCV() {
        return this.getDimension() - this.beta.length;
    }

    public double getBeta(int n) {
        return this.beta[n];
    }

    public void setBeta(int n, double d) {
        this.beta[n] = d;
    }

    public double[] getBeta() {
        return this.beta;
    }

    public void setBeta(double[] dArray) {
        if (dArray.length != this.beta.length) {
            throw new IllegalArgumentException("Invalid length of beta");
        }
        this.beta = dArray;
    }

    public ListOfTalliesWithCV<Tally> getListOfTalliesWithCV() {
        return (ListOfTalliesWithCV)super.getListOfTallies();
    }

    public double getExpectedValue(int n) {
        return this.getListOfTalliesWithCV().getExpectedValue(n);
    }

    public void setExpectedValue(int n, double d) {
        this.getListOfTalliesWithCV().setExpectedValue(n, d);
    }

    public double[] getExpectedValues() {
        return this.getListOfTalliesWithCV().getExpectedValues();
    }

    public void setExpectedValues(double[] dArray) {
        this.getListOfTalliesWithCV().setExpectedValues(dArray);
    }

    public void estimateBeta() {
        ListOfTalliesWithCV<Tally> listOfTalliesWithCV = this.getListOfTalliesWithCV();
        listOfTalliesWithCV.estimateBeta();
        this.estimateBetaFromMatrix(listOfTalliesWithCV.getBeta());
    }

    public void estimateBetaFromMatrix(DoubleMatrix2D doubleMatrix2D) {
        int n;
        ListOfTalliesWithCV<Tally> listOfTalliesWithCV = this.getListOfTalliesWithCV();
        int n2 = this.getDimension() - this.beta.length;
        int n3 = this.beta.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = ((StatProbe)listOfTalliesWithCV.get(n)).average();
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = this.funcNoCV.evaluateGradient(n, dArray);
        }
        for (n = 0; n < n3; ++n) {
            this.beta[n] = 0.0;
            for (int i = 0; i < n2; ++i) {
                int n4 = n;
                this.beta[n4] = this.beta[n4] + doubleMatrix2D.getQuick(n, i) * dArray2[i];
            }
        }
    }

    @Override
    public FunctionOfMultipleMeansTallyWithCV clone() {
        FunctionOfMultipleMeansTallyWithCV functionOfMultipleMeansTallyWithCV = (FunctionOfMultipleMeansTallyWithCV)super.clone();
        functionOfMultipleMeansTallyWithCV.beta = (double[])this.beta.clone();
        LinCVFunction linCVFunction = new LinCVFunction(this.getDimension());
        functionOfMultipleMeansTallyWithCV.func = linCVFunction;
        linCVFunction.initFunctionOfMultipleMeansTallyWithCV(functionOfMultipleMeansTallyWithCV);
        return functionOfMultipleMeansTallyWithCV;
    }

    private static class LinCVFunction
    implements MultivariateFunction {
        private FunctionOfMultipleMeansTallyWithCV fcv;
        private int pplusq;
        private double[] tmp;

        public LinCVFunction(int n) {
            this.pplusq = n;
        }

        public void initFunctionOfMultipleMeansTallyWithCV(FunctionOfMultipleMeansTallyWithCV functionOfMultipleMeansTallyWithCV) {
            this.fcv = functionOfMultipleMeansTallyWithCV;
            this.tmp = new double[functionOfMultipleMeansTallyWithCV.getListOfTalliesWithCV().sizeWithoutCV()];
        }

        public int getDimension() {
            return this.pplusq;
        }

        public double evaluate(double ... dArray) {
            MultivariateFunction multivariateFunction = this.fcv.getFunctionWithoutCV();
            if (dArray.length != this.getDimension()) {
                throw new IllegalArgumentException("x has length " + dArray.length + ", which differs from the dimension " + this.getDimension());
            }
            int n = this.getDimension() - this.fcv.beta.length;
            System.arraycopy(dArray, 0, this.tmp, 0, n);
            double d = multivariateFunction.evaluate(this.tmp);
            ListOfTalliesWithCV<Tally> listOfTalliesWithCV = this.fcv.getListOfTalliesWithCV();
            for (int i = 0; i < this.fcv.beta.length; ++i) {
                d -= this.fcv.beta[i] * (dArray[n + i] - listOfTalliesWithCV.getExpectedValue(i));
            }
            return d;
        }

        public double evaluateGradient(int n, double ... dArray) {
            MultivariateFunction multivariateFunction = this.fcv.getFunctionWithoutCV();
            if (dArray.length != this.getDimension()) {
                throw new IllegalArgumentException("x has length " + dArray.length + ", which differs from the dimension " + this.getDimension());
            }
            int n2 = this.getDimension() - this.fcv.beta.length;
            if (n < n2) {
                System.arraycopy(dArray, 0, this.tmp, 0, n2);
                return multivariateFunction.evaluateGradient(n, this.tmp);
            }
            return -this.fcv.beta[n - n2];
        }
    }
}

