/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Tally
extends StatProbe
implements Cloneable {
    private int numObs;
    private double sumSquares;
    private final boolean isStable = true;
    private double curAverage;
    private double curSum2;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat");
    protected CIType confidenceInterval = CIType.CI_NONE;
    protected double level = 0.95;

    public Tally() {
        this.init();
    }

    public Tally(String string) {
        this.name = string;
        this.init();
    }

    public void init() {
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.minValue = Double.POSITIVE_INFINITY;
        this.sumValue = 0.0;
        this.sumSquares = 0.0;
        this.curAverage = 0.0;
        this.curSum2 = 0.0;
        this.numObs = 0;
    }

    public void add(double d) {
        if (this.collect) {
            if (d < this.minValue) {
                this.minValue = d;
            }
            if (d > this.maxValue) {
                this.maxValue = d;
            }
            ++this.numObs;
            this.sumValue += d;
            this.sumSquares += d * d;
            this.curSum2 += (double)(this.numObs - 1) * (d - this.curAverage) * (d - this.curAverage) / (double)this.numObs;
            this.curAverage += (d - this.curAverage) / (double)this.numObs;
        }
        this.notifyListeners(d);
    }

    public int numberObs() {
        return this.numObs;
    }

    public double average() {
        if (this.numObs < 1) {
            this.log.logp(Level.WARNING, "Tally", "average", "Tally " + this.name + ":   calling average() with " + this.numObs + " observation");
            return Double.NaN;
        }
        return this.curAverage;
    }

    public double variance() {
        if (this.numObs < 2) {
            this.log.logp(Level.WARNING, "Tally", "variance", "Tally " + this.name + ":   calling variance() with " + this.numObs + " observation");
            return Double.NaN;
        }
        return this.curSum2 / (double)(this.numObs - 1);
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public void confidenceIntervalNormal(double d, double[] dArray) {
        if (this.numObs < 2) {
            throw new RuntimeException("Tally " + this.name + ": Calling confidenceIntervalStudent with < 2 Observations");
        }
        dArray[0] = this.average();
        double d2 = NormalDist.inverseF01(0.5 * (d + 1.0));
        dArray[1] = d2 * Math.sqrt(this.variance() / (double)this.numObs);
    }

    public void confidenceIntervalStudent(double d, double[] dArray) {
        if (this.numObs < 2) {
            throw new RuntimeException("Tally " + this.name + ": Calling confidenceIntervalStudent with < 2 Observations");
        }
        dArray[0] = this.average();
        double d2 = StudentDist.inverseF(this.numObs - 1, 0.5 * (d + 1.0));
        dArray[1] = d2 * Math.sqrt(this.variance() / (double)this.numObs);
    }

    public String formatConfidenceIntervalNormal(double d, int n) {
        PrintfFormat printfFormat = new PrintfFormat();
        double[] dArray = new double[2];
        this.confidenceIntervalNormal(d, dArray);
        printfFormat.append("  " + 100.0 * d + "%");
        printfFormat.append(" confidence interval for mean: (");
        printfFormat.append(7 + n, n, n - 1, dArray[0] - dArray[1]).append(',');
        printfFormat.append(7 + n, n, n - 1, dArray[0] + dArray[1]).append(" )\n");
        return printfFormat.toString();
    }

    public String formatConfidenceIntervalNormal(double d) {
        return this.formatConfidenceIntervalNormal(d, 3);
    }

    public String formatCINormal(double d, int n) {
        return this.formatConfidenceIntervalNormal(d, n);
    }

    public String formatCINormal(double d) {
        return this.formatConfidenceIntervalNormal(d);
    }

    public String formatConfidenceIntervalStudent(double d, int n) {
        PrintfFormat printfFormat = new PrintfFormat();
        double[] dArray = new double[2];
        this.confidenceIntervalStudent(d, dArray);
        printfFormat.append("  " + 100.0 * d + "%");
        printfFormat.append(" confidence interval for mean: (");
        printfFormat.append(7 + n, n, n - 1, dArray[0] - dArray[1]).append(',');
        printfFormat.append(7 + n, n, n - 1, dArray[0] + dArray[1]).append(" )\n");
        return printfFormat.toString();
    }

    public String formatConfidenceIntervalStudent(double d) {
        return this.formatConfidenceIntervalStudent(d, 3);
    }

    public String formatCIStudent(double d, int n) {
        return this.formatConfidenceIntervalStudent(d, n);
    }

    public String formatCIStudent(double d) {
        return this.formatConfidenceIntervalStudent(d);
    }

    public String report() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("REPORT on Tally stat. collector ==> " + this.name);
        printfFormat.append("\n         min        max      average    standard dev.  ");
        printfFormat.append("num. obs.\n");
        printfFormat.append(13, 3, 2, this.minValue);
        printfFormat.append(12, 3, 2, this.maxValue);
        printfFormat.append(11, 3, 2, this.average());
        printfFormat.append(13, 3, 2, this.standardDeviation());
        printfFormat.append(13, this.numObs).append('\n');
        switch (this.confidenceInterval) {
            case CI_NORMAL: {
                printfFormat.append(this.formatConfidenceIntervalNormal(this.level));
                break;
            }
            case CI_STUDENT: {
                printfFormat.append(this.formatConfidenceIntervalStudent(this.level));
            }
        }
        return printfFormat.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reportAndConfidenceIntervalStudent(double d, int n) {
        CIType cIType = this.confidenceInterval;
        double d2 = this.level;
        try {
            this.confidenceInterval = CIType.CI_STUDENT;
            this.level = d;
            String string = this.report();
            return string;
        }
        finally {
            this.confidenceInterval = cIType;
            this.level = d2;
        }
    }

    public String reportAndConfidenceIntervalStudent(double d) {
        return this.reportAndConfidenceIntervalStudent(d, 3);
    }

    public String reportAndCIStudent(double d, int n) {
        return this.reportAndConfidenceIntervalStudent(d, n);
    }

    public String reportAndCIStudent(double d) {
        return this.reportAndConfidenceIntervalStudent(d);
    }

    public String shortReportHeader() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append(-8, "   min").append("   ");
        printfFormat.append(-8, "   max").append("   ");
        printfFormat.append(-10, " average").append("   ");
        printfFormat.append(-9, "std. dev.");
        if (this.showNobs) {
            printfFormat.append("   ").append(-4, "nobs.");
        }
        if (this.confidenceInterval != CIType.CI_NONE) {
            printfFormat.append("   ").append(-25, "conf. int.");
        }
        return printfFormat.toString();
    }

    public String shortReport() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append(8, 3, 2, this.min()).append("   ");
        printfFormat.append(8, 3, 2, this.max()).append("   ");
        printfFormat.append(10, 3, 2, this.average()).append("   ");
        if (this.numberObs() >= 2) {
            printfFormat.append(9, 3, 2, this.standardDeviation());
        } else {
            printfFormat.append(9, "---");
        }
        if (this.showNobs) {
            printfFormat.append("   ").append(5, this.numberObs());
        }
        if (this.confidenceInterval != CIType.CI_NONE) {
            double[] dArray = new double[2];
            switch (this.confidenceInterval) {
                case CI_NORMAL: {
                    this.confidenceIntervalNormal(this.level, dArray);
                    break;
                }
                case CI_STUDENT: {
                    this.confidenceIntervalStudent(this.level, dArray);
                }
            }
            printfFormat.append("   ").append(100.0 * this.level + "% (");
            printfFormat.append(9, 3, 2, dArray[0] - dArray[1]).append(',');
            printfFormat.append(9, 3, 2, dArray[0] + dArray[1]).append(")");
        }
        return printfFormat.toString();
    }

    public double getConfidenceLevel() {
        return this.level;
    }

    public void setConfidenceLevel(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("level < 0");
        }
        if (d >= 1.0) {
            throw new IllegalArgumentException("level >= 1");
        }
        this.level = d;
    }

    public void setConfidenceIntervalNone() {
        this.confidenceInterval = CIType.CI_NONE;
    }

    public void setConfidenceIntervalNormal() {
        this.confidenceInterval = CIType.CI_NORMAL;
    }

    public void setConfidenceIntervalStudent() {
        this.confidenceInterval = CIType.CI_STUDENT;
    }

    public void setShowNumberObs(boolean bl) {
        this.showNobs = bl;
    }

    public Tally clone() {
        try {
            return (Tally)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Tally can't clone");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CIType {
        CI_NONE,
        CI_NORMAL,
        CI_STUDENT;

    }
}

