/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs.dsol;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.AbstractSimProcess;
import umontreal.iro.lecuyer.simprocs.dsol.InterpretedThread;

public abstract class SimProcess
extends AbstractSimProcess {
    InterpretedThread process = new InterpretedThread(this);

    public SimProcess() {
        this.scheduledEvent = new ResumeEvent(this.process);
    }

    public static void init() {
        Sim.init();
    }

    public static void init(EventList eventList) {
        Sim.init(eventList);
    }

    public void delay(double d) {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Calling delay() for a dead process");
        }
        if (current != this) {
            throw new IllegalStateException("Calling delay() for a process not in EXECUTING state");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Calling delay() with negative delay");
        }
        this.scheduledEvent.schedule(d);
        this.process.suspend();
    }

    public void suspend() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Calling suspend() for a dead process");
        }
        if (AbstractSimProcess.current == this) {
            this.process.suspend();
            return;
        }
        if (this.scheduledEvent.time() >= 0.0) {
            this.scheduledEvent.cancel();
            this.scheduledEvent.setTime(-10.0);
            return;
        }
        if (this.scheduledEvent.time() == -20.0) {
            throw new IllegalStateException("Calling suspend() for a process in INITIAL state");
        }
        throw new IllegalStateException("Calling suspend() for a suspended process");
    }

    public void kill() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Calling kill() on a DEAD process");
        }
        if (AbstractSimProcess.current == this) {
            this.scheduledEvent = null;
            InterpretedThread interpretedThread = this.process;
            this.process = null;
            interpretedThread.suspend();
            return;
        }
        if (this.scheduledEvent.time() >= 0.0) {
            this.scheduledEvent.cancel();
        }
        this.scheduledEvent = null;
        this.process = null;
    }

    void setScheduledEvent(Event event) {
        this.scheduledEvent = event;
    }

    private class ResumeEvent
    extends Event {
        private InterpretedThread target = null;

        public ResumeEvent(InterpretedThread interpretedThread) {
            this.target = interpretedThread;
            this.setTime(-20.0);
        }

        public void actions() {
            current = SimProcess.this;
            this.target.resume();
        }

        public String toString() {
            return "Start or resume process " + SimProcess.this.toString();
        }
    }
}

