/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.SimThreadError;

final class SimThread
extends Event
implements Runnable {
    static SimThreadError error = new SimThreadError();
    private int n = 0;
    SimProcess myProcess;
    private Thread myThread;
    private static SimThread allThreads = null;
    private SimThread nextAll = null;
    private static SimThread freeThreads = null;
    private SimThread nextFree = null;

    private SimThread(SimProcess simProcess) {
        this.eventTime = -20.0;
        this.myProcess = simProcess;
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.start();
        this.nextAll = allThreads;
        allThreads = this;
    }

    public static final SimThread getThread(SimProcess simProcess) {
        if (freeThreads == null) {
            return new SimThread(simProcess);
        }
        SimThread simThread = freeThreads;
        freeThreads = SimThread.freeThreads.nextFree;
        simThread.myProcess = simProcess;
        simThread.eventTime = -20.0;
        return simThread;
    }

    public final void run() {
        while (true) {
            try {
                this.passivate();
                this.myProcess.actions();
                SimThread simThread = this;
                simThread.myProcess.dispatch();
            }
            catch (SimThreadError simThreadError) {
                // empty catch block
            }
            this.myProcess.scheduledEvent = null;
            this.myProcess = null;
            this.nextFree = freeThreads;
            freeThreads = this;
        }
    }

    public void actions() {
        SimProcess.current = this.myProcess;
        this.activate();
        SimThread.simPassivate();
    }

    protected final synchronized void activate() {
        ++this.n;
        this.notify();
    }

    protected final synchronized void passivate() {
        try {
            --this.n;
            if (this.n < 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            ++this.n;
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void simActivate() {
        EventList eventList;
        EventList eventList2 = eventList = Sim.getEventList();
        synchronized (eventList2) {
            eventList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void simPassivate() {
        EventList eventList;
        EventList eventList2 = eventList = Sim.getEventList();
        synchronized (eventList2) {
            try {
                eventList.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void kill() {
        if (this.eventTime >= 0.0) {
            this.cancel();
        }
        this.myThread.interrupt();
    }

    protected static void killAll() {
        SimThread simThread = allThreads;
        while (simThread != null) {
            if (simThread.myProcess != null) {
                simThread.kill();
            }
            simThread = simThread.nextAll;
        }
    }

    public String toString() {
        return "Start or resume process " + this.myProcess.toString();
    }
}

