/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import java.util.Observable;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simprocs.AbstractSimProcess;
import umontreal.iro.lecuyer.simprocs.UserRecord;

public class Condition
extends Observable {
    private String name;
    private LinkedListStat<UserRecord> waitingList = new LinkedListStat();
    private boolean state;
    private boolean broadcasting;

    public Condition(boolean bl) {
        this.broadcasting = false;
        this.state = bl;
    }

    public Condition(boolean bl, String string) {
        this.name = string;
        this.broadcasting = false;
        this.state = bl;
    }

    public void init(boolean bl) {
        this.waitingList.clear();
        this.state = bl;
        if (this.broadcasting) {
            this.setChanged();
            this.notifyObservers(new Boolean(this.state));
        }
    }

    public void set(boolean bl) {
        this.state = bl;
        if (this.state) {
            while (!this.waitingList.isEmpty()) {
                UserRecord userRecord = this.waitingList.removeLast();
                userRecord.process.resume();
            }
        }
        if (this.broadcasting) {
            this.setChanged();
            this.notifyObservers(new Boolean(bl));
        }
    }

    public boolean state() {
        return this.state;
    }

    public void waitFor() {
        AbstractSimProcess abstractSimProcess = AbstractSimProcess.current;
        if (this.state) {
            if (this.waitingList.statSojourn() != null) {
                this.waitingList.statSojourn().add(0.0);
            }
            return;
        }
        UserRecord userRecord = new UserRecord(1, abstractSimProcess);
        this.waitingList.addLast(userRecord);
        abstractSimProcess.suspend();
    }

    public LinkedListStat waitList() {
        return this.waitingList;
    }

    public String getName() {
        return this.name;
    }

    public void setBroadcasting(boolean bl) {
        this.broadcasting = bl;
    }
}

