/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import java.util.ListIterator;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simprocs.AbstractSimProcess;
import umontreal.iro.lecuyer.simprocs.UserRecord;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Bin {
    private static final int FIFO = 1;
    private static final int LIFO = 2;
    private String name;
    private int available = 0;
    private int policy = 1;
    private LinkedListStat<UserRecord> waitingList = new LinkedListStat();
    private ListIterator<UserRecord> iter;
    private Accumulate statAvail;
    private boolean stats;
    private double initStatTime;

    public Bin() {
        this.iter = this.waitingList.listIterator();
        this.stats = false;
    }

    public Bin(String string) {
        this.name = string;
        this.iter = this.waitingList.listIterator();
        this.stats = false;
    }

    public void init() {
        int n = this.available;
        this.waitingList.clear();
        this.available = 0;
        if (this.stats) {
            this.initStat();
        }
    }

    public void setStatCollecting(boolean bl) {
        if (bl) {
            if (this.stats) {
                throw new IllegalStateException("Already collecting statistics for this resource");
            }
            this.stats = true;
            this.waitingList.setStatCollecting(true);
            if (this.statAvail != null) {
                this.initStat();
            } else {
                this.statAvail = new Accumulate("StatOnAvail");
                this.statAvail.update(this.available);
            }
        } else {
            if (this.stats) {
                throw new IllegalStateException("Not collecting statistics for this resource");
            }
            this.stats = false;
            this.waitingList.setStatCollecting(false);
        }
    }

    public void initStat() {
        if (!this.stats) {
            throw new IllegalStateException("Not collecting statistics for this resource");
        }
        this.statAvail.init();
        this.statAvail.update(this.available);
        this.waitingList.initStat();
        this.initStatTime = Sim.time();
    }

    public void setPolicyFIFO() {
        this.policy = 1;
    }

    public void setPolicyLIFO() {
        this.policy = 2;
    }

    public int getAvailable() {
        return this.available;
    }

    public void take(int n) {
        AbstractSimProcess abstractSimProcess = AbstractSimProcess.current;
        if (n <= this.available) {
            this.available -= n;
            if (this.stats) {
                this.statAvail.update(this.available);
                this.waitingList.statSojourn().add(0.0);
            }
        } else {
            UserRecord userRecord = new UserRecord(n, abstractSimProcess);
            switch (this.policy) {
                case 1: {
                    this.waitingList.addLast(userRecord);
                    break;
                }
                case 2: {
                    this.waitingList.addFirst(userRecord);
                    break;
                }
                default: {
                    throw new IllegalStateException("the policy must be LIFO or FIFO");
                }
            }
            abstractSimProcess.suspend();
        }
    }

    public void put(int n) {
        this.available += n;
        if (this.stats) {
            this.statAvail.update(this.available);
        }
        if (this.waitingList.size() > 0) {
            this.wakeProcess();
        }
    }

    private void wakeProcess() {
        ListIterator listIterator = this.waitingList.listIterator();
        while (listIterator.hasNext() && this.available > 0) {
            UserRecord userRecord = (UserRecord)listIterator.next();
            if (!userRecord.process.isAlive()) {
                throw new IllegalStateException("process not alive");
            }
            if (userRecord.numUnits > this.available) continue;
            userRecord.process.resume();
            this.available -= userRecord.numUnits;
            if (this.stats) {
                this.statAvail.update(this.available);
            }
            listIterator.remove();
        }
    }

    public LinkedListStat waitList() {
        return this.waitingList;
    }

    public Accumulate statOnAvail() {
        return this.statAvail;
    }

    public String report() {
        if (this.statAvail == null) {
            throw new IllegalStateException("Asking a report for a bin for which setStatCollecting (true) has not been called");
        }
        Accumulate accumulate = this.waitingList.statSize();
        Tally tally = this.waitingList.statSojourn();
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("REPORT ON BIN : ").append(this.name).append('\n');
        printfFormat.append("   From time : ").append(7, 2, 2, this.initStatTime);
        printfFormat.append("   to time : ");
        printfFormat.append(10, 2, 2, Sim.time());
        printfFormat.append("\n                    min        max     average  ");
        printfFormat.append("standard dev.  nb. obs.");
        printfFormat.append("\n   Available tokens ");
        printfFormat.append(8, (int)(this.statAvail.min() + 0.5));
        printfFormat.append(11, (int)(this.statAvail.max() + 0.5));
        printfFormat.append(12, 3, 2, this.statAvail.average());
        printfFormat.append("\n   Queue Size  ");
        printfFormat.append(8, (int)(accumulate.min() + 0.5));
        printfFormat.append(11, (int)(accumulate.max() + 0.5));
        printfFormat.append(12, 3, 2, accumulate.average());
        printfFormat.append("\n   Wait    ");
        printfFormat.append(12, 3, 2, tally.min()).append(' ');
        printfFormat.append(10, 3, 2, tally.max()).append(' ');
        printfFormat.append(11, 3, 2, tally.average()).append(' ');
        printfFormat.append(10, 3, 2, tally.standardDeviation());
        printfFormat.append(10, tally.numberObs());
        return printfFormat.toString();
    }
}

