/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simexp;

import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simexp.SimExp;

public abstract class RepSim
extends SimExp {
    private int minReps;
    private int maxReps;
    private int targetReps;
    private int doneReps;

    public RepSim(int n) {
        this(n, Integer.MAX_VALUE);
    }

    public RepSim(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("minReps <= 0");
        }
        if (n > n2) {
            throw new IllegalArgumentException("minReps > maxReps");
        }
        this.minReps = n;
        this.maxReps = n2;
        this.targetReps = n;
    }

    public int getMinReplications() {
        return this.minReps;
    }

    public void setMinReplications(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("minReps <= 0");
        }
        this.minReps = n;
        if (this.maxReps < n) {
            this.maxReps = n;
        }
    }

    public int getMaxReplications() {
        return this.maxReps;
    }

    public void setMaxReplications(int n) {
        if (n < this.minReps) {
            throw new IllegalArgumentException("maxReps < minReps");
        }
        this.maxReps = n;
    }

    public int getTargetReplications() {
        return this.targetReps;
    }

    public void setTargetReplications(int n) {
        if (n < this.minReps) {
            throw new IllegalArgumentException("Target number of replications too small");
        }
        if (n > this.maxReps) {
            throw new IllegalArgumentException("Target number of replications too large");
        }
        this.targetReps = n;
    }

    public int getCompletedReplications() {
        return this.doneReps;
    }

    public abstract void initReplicationProbes();

    public void performReplication(int n) {
        Sim.init();
        this.initReplication(n);
        Sim.start();
        this.replicationDone();
        this.addReplicationObs(n);
    }

    protected void replicationDone() {
        ++this.doneReps;
    }

    public abstract void initReplication(int var1);

    public abstract void addReplicationObs(int var1);

    public int getRequiredNewReplications() {
        return 0;
    }

    public void init() {
        if (this.simulating) {
            throw new IllegalStateException("Already simulating");
        }
        this.doneReps = 0;
        if (this.targetReps < this.minReps) {
            this.targetReps = this.minReps;
        }
        this.initReplicationProbes();
    }

    public void adjustTargetReplications(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("numReplications < 0");
        }
        if (n == 0) {
            return;
        }
        this.targetReps = this.doneReps + n;
        if (this.targetReps > this.maxReps) {
            this.targetReps = this.maxReps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulate() {
        this.init();
        this.simulating = true;
        try {
            while (this.doneReps < this.targetReps) {
                for (int i = 0; i < this.targetReps; ++i) {
                    this.performReplication(i);
                }
                this.adjustTargetReplications(this.getRequiredNewReplications());
            }
        }
        finally {
            this.simulating = false;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("minimal number of replications: ").append(this.minReps);
        if (this.maxReps < Integer.MAX_VALUE) {
            stringBuffer.append(", maximal number of replications: ").append(this.maxReps);
        }
        stringBuffer.append(", target number of replications: ").append(this.targetReps);
        if (this.simulating) {
            stringBuffer.append(", simulation in progress");
        } else {
            stringBuffer.append(", simulation stopped");
        }
        stringBuffer.append(", number of completed replications: ").append(this.doneReps);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

