/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simevents.eventlist.SplayTree;

public final class Sim {
    protected static double currentTime = 0.0;
    protected static EventList eventList = new SplayTree();
    protected static boolean stopped = false;

    private Sim() {
    }

    public static double time() {
        return currentTime;
    }

    public static void init() {
        currentTime = 0.0;
        eventList.clear();
        stopped = false;
    }

    public static void init(EventList eventList) {
        Sim.init();
        Sim.eventList = eventList;
    }

    public static EventList getEventList() {
        return eventList;
    }

    public static Event removeFirstEvent() {
        if (stopped) {
            return null;
        }
        Event event = eventList.removeFirst();
        if (event == null) {
            return null;
        }
        currentTime = event.eventTime;
        event.eventTime = -10.0;
        return event;
    }

    public static void start() {
        Event event;
        if (eventList.isEmpty()) {
            throw new IllegalStateException("Sim.start with empty event list");
        }
        stopped = false;
        while ((event = Sim.removeFirstEvent()) != null) {
            event.actions();
        }
    }

    public static void stop() {
        stopped = true;
    }
}

