/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;
import umontreal.iro.lecuyer.util.TransformingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWithStat<E>
extends TransformingList<E, Node<E>> {
    private boolean stats;
    private double initTime;
    private Accumulate blockSize;
    private Tally blockSojourn;
    private String name;

    public ListWithStat(List<Node<E>> list) {
        super(list);
        list.clear();
        this.stats = false;
    }

    public ListWithStat(List<Node<E>> list, Collection<? extends E> collection) {
        this((List<Node<? extends E>>)list);
        this.addAll(collection);
    }

    public ListWithStat(List<Node<E>> list, String string) {
        this(list);
        this.name = string;
    }

    public ListWithStat(List<Node<E>> list, Collection<? extends E> collection, String string) {
        this((List<Node<? extends E>>)list);
        this.name = string;
        this.addAll(collection);
    }

    @Override
    public E convertFromInnerType(Node<E> node) {
        return node.getElement();
    }

    @Override
    public Node<E> convertToInnerType(E e) {
        return new Node<E>(e, Sim.time());
    }

    @Override
    public void clear() {
        if (this.stats) {
            this.initStat();
        }
        super.clear();
    }

    @Override
    public void add(int n, E e) {
        super.add(n, e);
        if (this.stats) {
            this.blockSize.update(this.size());
        }
    }

    @Override
    public E remove(int n) {
        Node node = (Node)this.getInnerList().get(n);
        if (this.stats) {
            this.blockSojourn.add(Sim.time() - node.getInsertionTime());
        }
        Object OE = super.remove(n);
        if (this.stats) {
            this.blockSize.update(this.size());
        }
        return (E)OE;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorWithStat(this.getInnerList().iterator());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorWithStat(this.getInnerList().listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListIteratorWithStat(this.getInnerList().listIterator(n));
    }

    @Override
    public E set(int n, E e) {
        Node node = (Node)this.getInnerList().get(n);
        Object e2 = node.getElement();
        boolean bl = e2 == null || e == null ? e2 == e2 : e2.equals(e);
        if (bl) {
            this.getInnerList().set(n, new Node<E>(e, node.getInsertionTime()));
            return e2;
        }
        if (this.stats) {
            this.blockSojourn.add(Sim.time() - node.getInsertionTime());
        }
        this.getInnerList().set(n, new Node<E>(e, Sim.time()));
        return e2;
    }

    public boolean getStatCollecting() {
        return this.stats;
    }

    public void setStatCollecting(boolean bl) {
        if (bl && !this.stats) {
            if (this.blockSize == null) {
                this.blockSize = new Accumulate("List Size " + this.name);
            }
            if (this.blockSojourn == null) {
                this.blockSojourn = new Tally("List Sojourn " + this.name);
            }
            this.blockSize.update(this.size());
            this.stats = true;
            this.initStat();
        } else {
            this.stats = false;
        }
    }

    public void initStat() {
        if (!this.stats) {
            throw new IllegalStateException("initStat for a list that did not call setStatCollecting (true).");
        }
        this.blockSize.init();
        this.blockSojourn.init();
        this.blockSize.update(this.size());
        this.initTime = Sim.time();
    }

    public double getInitTime() {
        return this.initTime;
    }

    public Accumulate statSize() {
        return this.blockSize;
    }

    public Tally statSojourn() {
        return this.blockSojourn;
    }

    public String report() {
        if (this.blockSojourn == null || this.blockSize == null) {
            throw new IllegalStateException("Calling report when no statistics were collected");
        }
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("\nREPORT ON LIST : ").append(this.name).append('\n');
        printfFormat.append("   From time: ").append(7, 2, 2, this.initTime);
        printfFormat.append(" to time: ").append(10, 2, 2, Sim.time());
        printfFormat.append("                  min        max      average  ");
        printfFormat.append("standard dev.  nb. Obs");
        printfFormat.append("   Size    ");
        printfFormat.append(9, (int)(this.blockSize.min() + 0.5));
        printfFormat.append(11, (int)(this.blockSize.max() + 0.5));
        printfFormat.append(14, 3, 2, this.blockSize.average()).append('\n');
        printfFormat.append("   Sojourn ");
        printfFormat.append(12, 3, 2, this.blockSojourn.min()).append(" ");
        printfFormat.append(10, 3, 2, this.blockSojourn.max()).append(" ");
        printfFormat.append(10, 3, 2, this.blockSojourn.average()).append(" ");
        printfFormat.append(10, 3, 2, this.blockSojourn.standardDeviation()).append(" ");
        printfFormat.append(11, this.blockSojourn.numberObs()).append('\n');
        return printfFormat.toString();
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node<E> {
        private E element;
        private double insertionTime;

        public Node(E e, double d) {
            this.element = e;
            this.insertionTime = d;
        }

        public E getElement() {
            return this.element;
        }

        public double getInsertionTime() {
            return this.insertionTime;
        }

        public String toString() {
            String string = this.element == null ? "null" : this.element.toString();
            string = string + " (inserted at time " + this.insertionTime + ")";
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIteratorWithStat
    implements ListIterator<E> {
        private ListIterator<Node<E>> itr;
        private Node<E> lastRet;

        public ListIteratorWithStat(ListIterator<Node<E>> listIterator) {
            this.itr = listIterator;
        }

        @Override
        public void add(E e) {
            this.itr.add(new Node(e, Sim.time()));
            this.lastRet = null;
            if (ListWithStat.this.stats) {
                ListWithStat.this.blockSize.update(ListWithStat.this.size());
            }
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            this.lastRet = this.itr.next();
            return this.lastRet.getElement();
        }

        @Override
        public int nextIndex() {
            return this.itr.nextIndex();
        }

        @Override
        public E previous() {
            this.lastRet = this.itr.previous();
            return this.lastRet.getElement();
        }

        @Override
        public int previousIndex() {
            return this.itr.previousIndex();
        }

        @Override
        public void remove() {
            this.itr.remove();
            if (ListWithStat.this.stats) {
                ListWithStat.this.blockSize.update(ListWithStat.this.size());
                ListWithStat.this.blockSojourn.add(Sim.time() - this.lastRet.getInsertionTime());
            }
            this.lastRet = null;
        }

        @Override
        public void set(E e) {
            if (this.lastRet == null) {
                throw new NoSuchElementException();
            }
            Node node = this.lastRet;
            Object e2 = node.getElement();
            boolean bl = e2 == null || e == null ? e2 == e2 : e2.equals(e);
            if (bl) {
                this.lastRet = new Node(e, node.getInsertionTime());
                this.itr.set(this.lastRet);
            } else {
                if (ListWithStat.this.stats) {
                    ListWithStat.this.blockSojourn.add(Sim.time() - node.getInsertionTime());
                }
                this.lastRet = new Node(e, Sim.time());
                this.itr.set(this.lastRet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorWithStat
    implements Iterator<E> {
        private Iterator<Node<E>> itr;
        private Node<E> lastRet;

        public IteratorWithStat(Iterator<Node<E>> iterator) {
            this.itr = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public E next() {
            this.lastRet = this.itr.next();
            return this.lastRet.getElement();
        }

        @Override
        public void remove() {
            this.itr.remove();
            if (ListWithStat.this.stats) {
                ListWithStat.this.blockSize.update(ListWithStat.this.size());
                ListWithStat.this.blockSojourn.add(Sim.time() - this.lastRet.getInsertionTime());
            }
            this.lastRet = null;
        }
    }
}

