/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Sim;

public abstract class Event {
    protected double eventTime = -10.0;

    public void schedule(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Cannot schedule in the past.");
        }
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = Sim.time() + d;
        Sim.eventList.add(this);
    }

    public void scheduleNext() {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = Sim.time();
        Sim.eventList.addFirst(this);
    }

    public void scheduleBefore(Event event) {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = event.eventTime;
        Sim.eventList.addBefore(this, event);
    }

    public void scheduleAfter(Event event) {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = event.eventTime;
        Sim.eventList.addAfter(this, event);
    }

    public void reschedule(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Cannot schedule in the past.");
        }
        if (this.eventTime < -1.0) {
            throw new IllegalStateException("Event not scheduled");
        }
        Sim.eventList.remove(this);
        this.eventTime = Sim.time() + d;
        Sim.eventList.add(this);
    }

    public boolean cancel() {
        boolean bl = false;
        if (this.eventTime >= Sim.time()) {
            bl = Sim.eventList.remove(this);
        }
        this.eventTime = -10.0;
        return bl;
    }

    public static final boolean cancel(String string) {
        Event event = Sim.eventList.getFirstOfClass(string);
        return event.cancel();
    }

    public final double time() {
        return this.eventTime;
    }

    public final double setTime(double d) {
        this.eventTime = d;
        return this.eventTime;
    }

    public abstract void actions();
}

