/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Accumulate
extends StatProbe
implements Cloneable {
    private double initTime;
    private double lastTime;
    private double lastValue;

    public Accumulate() {
        this.init();
    }

    public Accumulate(String string) {
        this.name = string;
        this.init();
    }

    public void init() {
        this.maxValue = Double.MIN_VALUE;
        this.minValue = Double.MAX_VALUE;
        this.lastValue = 0.0;
        this.sumValue = 0.0;
        this.initTime = this.lastTime = Sim.time();
    }

    public void init(double d) {
        this.init();
        this.update(d);
    }

    public void update() {
        this.update(this.lastValue);
    }

    public void update(double d) {
        if (this.collect) {
            double d2 = Sim.time();
            if (d < this.minValue) {
                this.minValue = d;
            }
            if (d > this.maxValue) {
                this.maxValue = d;
            }
            this.sumValue += this.lastValue * (d2 - this.lastTime);
            this.lastValue = d;
            this.lastTime = d2;
        }
        if (this.broadcast) {
            this.notifyListeners(d);
        }
    }

    public double sum() {
        this.update(this.lastValue);
        return this.sumValue;
    }

    public double average() {
        this.update(this.lastValue);
        double d = this.lastTime - this.initTime;
        if (d > 0.0) {
            return this.sumValue / d;
        }
        return 0.0;
    }

    public String shortReportHeader() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append(-9, "from time").append("   ");
        printfFormat.append(-9, "to time").append("   ");
        printfFormat.append(-8, "   min").append("   ");
        printfFormat.append(-8, "   max").append("   ");
        printfFormat.append(-10, " average");
        return printfFormat.toString();
    }

    public String shortReport() {
        this.update();
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append(9, 2, 2, this.getInitTime()).append("   ");
        printfFormat.append(9, 2, 2, this.getLastTime()).append("   ");
        printfFormat.append(8, 3, 2, this.min()).append("   ");
        printfFormat.append(8, 3, 2, this.max()).append("   ");
        printfFormat.append(10, 3, 2, this.average());
        return printfFormat.toString();
    }

    public String report() {
        this.update(this.lastValue);
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("REPORT on Accumulate stat. collector ==> " + this.name);
        printfFormat.append("\n      from time   to time       min         max");
        printfFormat.append("         average").append('\n');
        printfFormat.append(12, 2, 2, this.initTime);
        printfFormat.append(13, 2, 2, this.lastTime);
        printfFormat.append(11, 3, 2, this.minValue);
        printfFormat.append(12, 3, 2, this.maxValue);
        printfFormat.append(14, 3, 2, this.average()).append('\n');
        return printfFormat.toString();
    }

    public double getInitTime() {
        return this.initTime;
    }

    public double getLastTime() {
        return this.lastTime;
    }

    public double getLastValue() {
        return this.lastValue;
    }

    public Accumulate clone() {
        try {
            return (Accumulate)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Accumulate can't clone");
        }
    }
}

