/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;

public class Pearson6Dist
extends ContinuousDistribution {
    protected double alpha1;
    protected double alpha2;
    protected double beta;

    public Pearson6Dist(double d, double d2, double d3) {
        this.setParam(d, d2, d3);
    }

    public double density(double d) {
        return Pearson6Dist.density(this.alpha1, this.alpha2, this.beta, d);
    }

    public double cdf(double d) {
        return Pearson6Dist.cdf(this.alpha1, this.alpha2, this.beta, d);
    }

    public double barF(double d) {
        return Pearson6Dist.barF(this.alpha1, this.alpha2, this.beta, d);
    }

    public double inverseF(double d) {
        return Pearson6Dist.inverseF(this.alpha1, this.alpha2, this.beta, d);
    }

    public double getMean() {
        return Pearson6Dist.getMean(this.alpha1, this.alpha2, this.beta);
    }

    public double getVariance() {
        return Pearson6Dist.getVariance(this.alpha1, this.alpha2, this.beta);
    }

    public double getStandardDeviation() {
        return Pearson6Dist.getStandardDeviation(this.alpha1, this.alpha2, this.beta);
    }

    public static double density(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("alpha2 <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d4 <= 0.0) {
            return 0.0;
        }
        return Math.exp((d - 1.0) * Math.log(d4 / d3) - (Math.log(d3) + Num.lnGamma(d) + Num.lnGamma(d2) - Num.lnGamma(d + d2) + (d + d2) * Math.log(1.0 + d4 / d3)));
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("alpha2 <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d4 <= 0.0) {
            return 0.0;
        }
        return BetaDist.cdf(d, d2, 15, d4 / (d4 + d3));
    }

    public static double barF(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("alpha2 <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d4 <= 0.0) {
            return 1.0;
        }
        return 1.0 - BetaDist.cdf(d, d2, 15, d4 / (d4 + d3));
    }

    public static double inverseF(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("alpha2 <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double d5 = BetaDist.inverseF(d, d2, 15, d4);
        return d5 * d3 / (1.0 - d5);
    }

    public static Pearson6Dist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = Pearson6Dist.getMaximumLikelihoodEstimate(dArray, n);
        return new Pearson6Dist(dArray2[0], dArray2[1], dArray2[2]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[4];
        double[] dArray6 = new double[4];
        int[] nArray = new int[2];
        double[][] dArray7 = new double[4][4];
        double[] dArray8 = new double[4];
        Optim optim = new Optim(dArray, n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
            d2 += dArray[i] * dArray[i];
            d3 += dArray[i] * dArray[i] * dArray[i];
        }
        double d4 = (d2 /= (double)n) / ((d /= (double)n) * d);
        double d5 = d2 * d / (d3 /= (double)n);
        dArray4[1] = -(2.0 * (-1.0 + d4 * d5)) / (-2.0 + d4 + d4 * d5);
        dArray4[2] = (-3.0 - d5 + 4.0 * d4 * d5) / (-1.0 - d5 + 2.0 * d4 * d5);
        dArray4[3] = (dArray4[2] - 1.0) * d / dArray4[1];
        Uncmin_f77.optif0_f77((int)3, (double[])dArray4, (Uncmin_methods)optim, (double[])dArray3, (double[])dArray5, (double[])dArray6, (int[])nArray, (double[][])dArray7, (double[])dArray8);
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = dArray3[i + 1];
        }
        return dArray2;
    }

    public static double getMean(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("alpha2 <= 1");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d3 * d / (d2 - 1.0);
    }

    public static double getVariance(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("alpha2 <= 2");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d3 * d3 * d * (d + d2 - 1.0) / ((d2 - 1.0) * (d2 - 1.0) * (d2 - 2.0));
    }

    public static double getStandardDeviation(double d, double d2, double d3) {
        return Math.sqrt(Pearson6Dist.getVariance(d, d2, d3));
    }

    public double getAlpha1() {
        return this.alpha1;
    }

    public double getAlpha2() {
        return this.alpha2;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParam(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("alpha2 <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha1 = d;
        this.alpha2 = d2;
        this.beta = d3;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] x;

        public Optim(double[] dArray, int n) {
            this.n = n;
            this.x = new double[n];
            System.arraycopy(dArray, 0, this.x, 0, n);
        }

        public double f_to_minimize(double[] dArray) {
            if (dArray[1] <= 0.0 || dArray[2] <= 0.0 || dArray[3] <= 0.0) {
                return 1.0E200;
            }
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                d += Math.log(this.x[i] / dArray[3]);
                d2 += Math.log(1.0 + this.x[i] / dArray[3]);
            }
            return (double)this.n * (Math.log(dArray[3]) + Num.lnGamma(dArray[1]) + Num.lnGamma(dArray[2]) - Num.lnGamma(dArray[1] + dArray[2])) - (dArray[1] - 1.0) * d + (dArray[1] + dArray[2]) * d2;
        }

        public void gradient(double[] dArray, double[] dArray2) {
        }

        public void hessian(double[] dArray, double[][] dArray2) {
        }
    }
}

