/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class Pearson5Dist
extends ContinuousDistribution {
    protected double alpha;
    protected double beta;

    public Pearson5Dist(double d, double d2) {
        this.setParam(d, d2);
    }

    public double density(double d) {
        return Pearson5Dist.density(this.alpha, this.beta, d);
    }

    public double cdf(double d) {
        return Pearson5Dist.cdf(this.alpha, this.beta, d);
    }

    public double barF(double d) {
        return Pearson5Dist.barF(this.alpha, this.beta, d);
    }

    public double inverseF(double d) {
        return Pearson5Dist.inverseF(this.alpha, this.beta, d);
    }

    public double getMean() {
        return Pearson5Dist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return Pearson5Dist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return Pearson5Dist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return Math.exp(d * Math.log(d2) - (d + 1.0) * Math.log(d3) - d2 / d3 - Num.lnGamma(d));
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return GammaDist.barF(d, d2, 15, 1.0 / d3);
    }

    public static double barF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            return 1.0;
        }
        return GammaDist.cdf(d, d2, 15, 1.0 / d3);
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return 1.0 / GammaDist.inverseF(d, d2, 15, 1.0 - d3);
    }

    public static Pearson5Dist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = Pearson5Dist.getMaximumLikelihoodEstimate(dArray, n);
        return new Pearson5Dist(dArray2[0], dArray2[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 1.0 / dArray[i];
        }
        return GammaDist.getMaximumLikelihoodEstimate(dArray2, n);
    }

    public static double getMean(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d2 / (d - 1.0);
    }

    public static double getVariance(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d2 * d2 / ((d - 1.0) * (d - 1.0) * (d - 2.0));
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(Pearson5Dist.getVariance(d, d2));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParam(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = d;
        this.beta = d2;
    }
}

