/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.NegativeBinomialDist;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.RootFinder;

public class PascalDist
extends NegativeBinomialDist {
    private int n;

    public PascalDist(int n, double d) {
        this.setParams(n, d);
    }

    public static PascalDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = PascalDist.getMaximumLikelihoodEstimate(nArray, n);
        return new PascalDist((int)dArray[0], dArray[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        double d;
        if (n <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        double d2 = (double)n2 / (double)n;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += ((double)nArray[i] - d2) * ((double)nArray[i] - d2);
        }
        d3 /= (double)n;
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                if (nArray[j] <= i) continue;
                ++n4;
            }
            nArray2[i] = n4;
        }
        double d4 = d2 / d3 - 0.1;
        if (d4 <= 0.0) {
            d4 = 1.0E-15;
        }
        double[] dArray = new double[2];
        Function function = new Function(n, n3, d2, nArray2);
        dArray[1] = RootFinder.brentDekker(d4, d4 + 0.2, function, 1.0E-5);
        if (dArray[1] >= 1.0) {
            dArray[1] = 0.999999999999999;
        }
        dArray[0] = Math.round(dArray[1] * d2 / (1.0 - dArray[1]));
        int n5 = (int)dArray[0];
        double d5 = d = Math.abs(function.evaluateN(n5, dArray[1]));
        double d6 = Math.abs(function.evaluateN(n5, dArray[1]));
        double d7 = Math.abs(function.evaluateN(n5, dArray[1]));
        if (d7 < d) {
            int n6 = n5 - 1;
            while (true) {
                double d8;
                double d9 = Math.abs(function.evaluateN(n6, dArray[1]));
                if (d8 < d5 && n6 >= 1) {
                    d5 = d9;
                    dArray[0] = n6;
                    --n6;
                    continue;
                }
                break;
            }
        } else if (d6 < d) {
            int n7 = n5 + 1;
            while (true) {
                double d10;
                double d11 = Math.abs(function.evaluateN(n7, dArray[1]));
                if (!(d10 < d5)) break;
                d5 = d11;
                dArray[0] = n7;
                ++n7;
            }
        }
        return dArray;
    }

    public int getN() {
        return this.n;
    }

    public void setParams(int n, double d) {
        this.setParams((double)n, d);
        this.n = n;
    }

    private static class Function
    implements MathFunction {
        protected int m;
        protected int max;
        protected double mean;
        protected int[] Fj;

        public Function(int n, int n2, double d, int[] nArray) {
            this.m = n;
            this.max = n2;
            this.mean = d;
            this.Fj = new int[nArray.length];
            System.arraycopy(nArray, 0, this.Fj, 0, nArray.length);
        }

        public double evaluate(double d) {
            double d2 = 0.0;
            double d3 = d * this.mean / (1.0 - d);
            for (int i = 0; i < this.max; ++i) {
                d2 += (double)this.Fj[i] / (d3 + (double)i);
            }
            return d2 + (double)this.m * Math.log(d);
        }

        public double evaluateN(int n, double d) {
            double d2 = 0.0;
            for (int i = 0; i < this.max; ++i) {
                d2 += (double)(this.Fj[i] / (n + i));
            }
            return d2 + (double)this.m * Math.log(d);
        }
    }
}

