/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.Num;

public class GeometricDist
extends DiscreteDistributionInt {
    private double p;
    private double vp;
    private static double pold = -1.0;
    private static double v = -1.0;

    public GeometricDist(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        this.setP(d);
        this.vp = Num.log1p(-d);
    }

    public double prob(int n) {
        return GeometricDist.prob(this.p, n);
    }

    public double cdf(int n) {
        return GeometricDist.cdf(this.p, n);
    }

    public double barF(int n) {
        return GeometricDist.barF(this.p, n);
    }

    public int inverseFInt(double d) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (this.p >= 1.0) {
            return 0;
        }
        if (d <= 0.0) {
            return 0;
        }
        if (d >= 1.0 || this.p <= 0.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        return (int)Math.floor(Num.log1p(-d) / this.vp);
    }

    public double getMean() {
        return GeometricDist.getMean(this.p);
    }

    public double getVariance() {
        return GeometricDist.getVariance(this.p);
    }

    public double getStandardDeviation() {
        return GeometricDist.getStandardDeviation(this.p);
    }

    public static double prob(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 0.0;
        }
        if (n < 0) {
            return 0.0;
        }
        return d * Math.pow(1.0 - d, n);
    }

    public static double cdf(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (n < 0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.pow(1.0 - d, (double)n + 1.0);
    }

    public static double barF(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (n < 0) {
            return 1.0;
        }
        if (d >= 1.0) {
            return 0.0;
        }
        if (d <= 0.0) {
            return 1.0;
        }
        return Math.pow(1.0 - d, n);
    }

    public static int inverseF(double d, double d2) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (d2 > 1.0 || d2 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d >= 1.0) {
            return 0;
        }
        if (d2 <= 0.0) {
            return 0;
        }
        if (d2 >= 1.0 || d <= 0.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        if (pold != d) {
            pold = d;
            v = Num.log1p(-d);
        }
        return (int)Math.floor(Num.log1p(-d2) / v);
    }

    public static GeometricDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = GeometricDist.getMaximumLikelihoodEstimate(nArray, n);
        return new GeometricDist(dArray[0]);
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray = new double[1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        dArray[0] = 1.0 / ((double)n2 / (double)n + 1.0);
        return dArray;
    }

    public static double getMean(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        return (1.0 - d) / d;
    }

    public static double getVariance(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        return (1.0 - d) / (d * d);
    }

    public static double getStandardDeviation(double d) {
        return Math.sqrt(GeometricDist.getVariance(d));
    }

    public double getP() {
        return this.p;
    }

    public void setP(double d) {
        this.p = d;
    }
}

