/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;

public class FisherFDist
extends ContinuousDistribution {
    protected int n;
    protected int m;

    public FisherFDist(int n, int n2) {
        this.setParams(n, n2);
    }

    public double density(double d) {
        return FisherFDist.density(this.n, this.m, d);
    }

    public double cdf(double d) {
        return FisherFDist.cdf(this.n, this.m, this.decPrec, d);
    }

    public double barF(double d) {
        return FisherFDist.barF(this.n, this.m, this.decPrec, d);
    }

    public double inverseF(double d) {
        return FisherFDist.inverseF(this.n, this.m, this.decPrec, d);
    }

    public double getMean() {
        return FisherFDist.getMean(this.n, this.m);
    }

    public double getVariance() {
        return FisherFDist.getVariance(this.n, this.m);
    }

    public double getStandardDeviation() {
        return FisherFDist.getStandardDeviation(this.n, this.m);
    }

    public static double density(int n, int n2, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        return Math.exp(Num.lnGamma((double)(n + n2) / 2.0) + (double)n / 2.0 * Math.log(n) + (double)n2 / 2.0 * Math.log(n2) + ((double)n - 2.0) / 2.0 * Math.log(d) - (Num.lnGamma((double)n / 2.0) + Num.lnGamma((double)n2 / 2.0) + (double)(n + n2) / 2.0 * Math.log((double)n2 + (double)n * d)));
    }

    public static double cdf(int n, int n2, int n3, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        return BetaDist.cdf((double)n / 2.0, (double)n2 / 2.0, n3, (double)n * d / ((double)n * d + (double)n2));
    }

    public static double barF(int n, int n2, int n3, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (d <= 0.0) {
            return 1.0;
        }
        return BetaDist.barF((double)n / 2.0, (double)n2 / 2.0, n3, (double)n * d / ((double)n * d + (double)n2));
    }

    public static double inverseF(int n, int n2, int n3, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("u < 0 or u > 1");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = BetaDist.inverseF((double)n / 2.0, (double)n2 / 2.0, n3, d);
        return (double)n2 * d2 / ((double)n * (1.0 - d2));
    }

    public static double getMean(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 2) {
            throw new IllegalArgumentException("m <= 2");
        }
        return (double)n2 / ((double)n2 - 2.0);
    }

    public static double getVariance(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 4) {
            throw new IllegalArgumentException("m <= 4");
        }
        return 2.0 * (double)n2 * (double)n2 * (double)(n2 + n - 2) / ((double)n * ((double)n2 - 2.0) * ((double)n2 - 2.0) * ((double)n2 - 4.0));
    }

    public static double getStandardDeviation(int n, int n2) {
        return Math.sqrt(FisherFDist.getVariance(n, n2));
    }

    public int getN() {
        return this.n;
    }

    public int getM() {
        return this.m;
    }

    public void setParams(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        this.n = n;
        this.m = n2;
    }
}

