/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class FatigueLifeDist
extends ContinuousDistribution {
    protected double mu;
    protected double beta;
    protected double gamma;

    public FatigueLifeDist(double d, double d2, double d3) {
        this.setParams(d, d2, d3);
    }

    public double density(double d) {
        return FatigueLifeDist.density(this.mu, this.beta, this.gamma, d);
    }

    public double cdf(double d) {
        return FatigueLifeDist.cdf(this.mu, this.beta, this.gamma, d);
    }

    public double barF(double d) {
        return FatigueLifeDist.barF(this.mu, this.beta, this.gamma, d);
    }

    public double inverseF(double d) {
        return FatigueLifeDist.inverseF(this.mu, this.beta, this.gamma, d);
    }

    public double getMean() {
        return FatigueLifeDist.getMean(this.mu, this.beta, this.gamma);
    }

    public double getVariance() {
        return FatigueLifeDist.getVariance(this.mu, this.beta, this.gamma);
    }

    public double getStandardDeviation() {
        return FatigueLifeDist.getStandardDeviation(this.mu, this.beta, this.gamma);
    }

    public static double density(double d, double d2, double d3, double d4) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (d4 <= d) {
            return 0.0;
        }
        double d5 = (Math.sqrt((d4 - d) / d2) - Math.sqrt(d2 / (d4 - d))) / d3;
        return (Math.sqrt((d4 - d) / d2) + Math.sqrt(d2 / (d4 - d))) / (2.0 * d3 * (d4 - d)) * NormalDist.density(0.0, 1.0, d5);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (d4 <= d) {
            return 0.0;
        }
        return NormalDist.cdf01((Math.sqrt((d4 - d) / d2) - Math.sqrt(d2 / (d4 - d))) / d3);
    }

    public static double barF(double d, double d2, double d3, double d4) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (d4 <= d) {
            return 1.0;
        }
        return NormalDist.barF01((Math.sqrt((d4 - d) / d2) - Math.sqrt(d2 / (d4 - d))) / d3);
    }

    public static double inverseF(double d, double d2, double d3, double d4) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (d4 > 1.0 || d4 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d4 <= 0.0) {
            return d;
        }
        double d5 = d3 * NormalDist.inverseF01(d4);
        double d6 = 0.5 * (d5 + Math.sqrt(d5 * d5 + 4.0));
        return d + d6 * d6 * d2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n, double d) {
        double d2 = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        int[] nArray = new int[2];
        double[][] dArray7 = new double[3][3];
        double[] dArray8 = new double[3];
        Optim optim = new Optim(dArray, n, d);
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += dArray[i];
        }
        d3 /= (double)n;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d4 += (dArray[i] - d3) * (dArray[i] - d3);
        }
        double d5 = (d3 - d) * (d3 - d);
        double d6 = 0.25 * ((d4 /= (double)n) - 5.0 * d5);
        double d7 = d4 - d5;
        double d8 = d4;
        double d9 = d7 * d7 - 4.0 * d6 * d8;
        double d10 = (-d7 - Math.sqrt(d9)) / (2.0 * d6);
        dArray4[2] = Math.sqrt(d10);
        dArray4[1] = (d3 - d) / (1.0 + d10 / 2.0);
        Uncmin_f77.optif0_f77((int)2, (double[])dArray4, (Uncmin_methods)optim, (double[])dArray3, (double[])dArray5, (double[])dArray6, (int[])nArray, (double[][])dArray7, (double[])dArray8);
        for (int i = 0; i < 2; ++i) {
            dArray2[i] = dArray3[i + 1];
        }
        return dArray2;
    }

    public static double getMean(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return d + d2 * (1.0 + 0.5 * d3 * d3);
    }

    public static double getVariance(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return d2 * d2 * d3 * d3 * (1.0 + 1.25 * d3 * d3);
    }

    public static double getStandardDeviation(double d, double d2, double d3) {
        return Math.sqrt(FatigueLifeDist.getVariance(d, d2, d3));
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getMu() {
        return this.mu;
    }

    public void setParams(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        this.mu = d;
        this.beta = d2;
        this.gamma = d3;
        this.supportA = d;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;
        private double mu;

        public Optim(double[] dArray, int n, double d) {
            this.n = n;
            this.mu = d;
            this.xi = new double[n];
            System.arraycopy(dArray, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] dArray) {
            double d = 0.0;
            if (dArray[1] <= 0.0 || dArray[2] <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                d -= Math.log(FatigueLifeDist.density(this.mu, dArray[1], dArray[2], this.xi[i]));
            }
            return d;
        }

        public void gradient(double[] dArray, double[] dArray2) {
        }

        public void hessian(double[] dArray, double[][] dArray2) {
        }
    }
}

