/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.RootFinder;

public class ExtremeValueDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;

    public ExtremeValueDist() {
        this.setParams(0.0, 1.0);
    }

    public ExtremeValueDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return ExtremeValueDist.density(this.alpha, this.lambda, d);
    }

    public double cdf(double d) {
        return ExtremeValueDist.cdf(this.alpha, this.lambda, d);
    }

    public double barF(double d) {
        return ExtremeValueDist.barF(this.alpha, this.lambda, d);
    }

    public double inverseF(double d) {
        return ExtremeValueDist.inverseF(this.alpha, this.lambda, d);
    }

    public double getMean() {
        return ExtremeValueDist.getMean(this.alpha, this.lambda);
    }

    public double getVariance() {
        return ExtremeValueDist.getVariance(this.alpha, this.lambda);
    }

    public double getStandardDeviation() {
        return ExtremeValueDist.getStandardDeviation(this.alpha, this.lambda);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d2 * Math.exp(-Math.exp(-d2 * (d3 - d)) - d2 * (d3 - d));
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= d - 1000.0 / d2) {
            return 0.0;
        }
        if (d3 >= d + 1000.0 / d2) {
            return 1.0;
        }
        return Math.exp(-Math.exp(-d2 * (d3 - d)));
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= d - 1000.0 / d2) {
            return 1.0;
        }
        if (d3 >= d + 1000.0 / d2) {
            return 0.0;
        }
        return 1.0 - Math.exp(-Math.exp(-d2 * (d3 - d)));
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 >= 1.0) {
            return d + 1000.0 / d2;
        }
        if (d3 <= 0.0) {
            return d - 1000.0 / d2;
        }
        return -Math.log(-Math.log(d3)) / d2 + d;
    }

    public static ExtremeValueDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = ExtremeValueDist.getMaximumLikelihoodEstimate(dArray, n);
        return new ExtremeValueDist(dArray2[0], dArray2[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        double d;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[2];
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += dArray[i];
        }
        double d3 = d2 / (double)n;
        d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += (dArray[i] - d3) * (dArray[i] - d3);
        }
        double d4 = d2 / ((double)n - 1.0);
        double d5 = Math.PI / Math.sqrt(6.0 * d4);
        Function function = new Function(dArray, n, d3);
        double d6 = d5 - 1.0;
        if (d < 0.0) {
            d6 = 1.0E-15;
        }
        dArray2[1] = RootFinder.brentDekker(d6, d5 + 1.0, function, 1.0E-15);
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d7 += Math.exp(-dArray[i] * dArray2[1]);
        }
        dArray2[0] = -Math.log(d7 / (double)n) / dArray2[1];
        return dArray2;
    }

    public static double getMean(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d + 0.5772156649015329 / d2;
    }

    public static double getVariance(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.6449340668482262 * (1.0 / (d2 * d2));
    }

    public static double getStandardDeviation(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(0.16666666666666666) * Math.PI / d2;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = d;
        this.lambda = d2;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double mean;
        protected double[] x;

        public Function(double[] dArray, int n, double d) {
            this.n = n;
            this.mean = d;
            this.x = new double[n];
            System.arraycopy(dArray, 0, this.x, 0, n);
        }

        public double evaluate(double d) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                d2 = Math.exp(-this.x[i] * d);
                d4 += d2;
                d3 += this.x[i] * d2;
            }
            return (this.mean - 1.0 / d) * d4 - d3;
        }
    }
}

