/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;

public class ExponentialDist
extends ContinuousDistribution {
    private double lambda;

    public ExponentialDist() {
        this.setLambda(1.0);
    }

    public ExponentialDist(double d) {
        this.setLambda(d);
    }

    public double density(double d) {
        return ExponentialDist.density(this.lambda, d);
    }

    public double cdf(double d) {
        return ExponentialDist.cdf(this.lambda, d);
    }

    public double barF(double d) {
        return ExponentialDist.barF(this.lambda, d);
    }

    public double inverseF(double d) {
        return ExponentialDist.inverseF(this.lambda, d);
    }

    public double getMean() {
        return ExponentialDist.getMean(this.lambda);
    }

    public double getVariance() {
        return ExponentialDist.getVariance(this.lambda);
    }

    public double getStandardDeviation() {
        return ExponentialDist.getStandardDeviation(this.lambda);
    }

    public static double density(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d2 < 0.0 ? 0.0 : d * Math.exp(-d * d2);
    }

    public static double cdf(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = d * d2;
        if (d3 >= 1000.0) {
            return 1.0;
        }
        if (d3 > 0.001) {
            return 1.0 - Math.exp(-d3);
        }
        return d3 * (1.0 - d3 * (0.5 - d3 * (0.16666666666666666 - d3 * (0.041666666666666664 - d3 * 1.0 / 120.0))));
    }

    public static double barF(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            return 1.0;
        }
        if (d * d2 >= 1000.0) {
            return 0.0;
        }
        return Math.exp(-d * d2);
    }

    public static double inverseF(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d2 >= 1.0) {
            return 1000.0 / d;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        return -Num.log1p(-d2) / d;
    }

    public static ExponentialDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = ExponentialDist.getMaximumLikelihoodEstimate(dArray, n);
        return new ExponentialDist(dArray2[0]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double d = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[1];
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        dArray2[0] = (double)n / d;
        return dArray2;
    }

    public static double getMean(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.0 / d;
    }

    public static double getVariance(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.0 / (d * d);
    }

    public static double getStandardDeviation(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.0 / d;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.lambda = d;
        this.supportA = 0.0;
    }
}

