/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.Distribution;

public abstract class DiscreteDistributionInt
implements Distribution {
    public static double EPSILON = 1.0E-16;
    protected static final double EPS_EXTRA = 0.01;
    protected double[] cdf = null;
    protected double[] pdf = null;
    protected int xmin = 0;
    protected int xmax = 0;
    protected int xmed = 0;

    public abstract double prob(int var1);

    public double cdf(double d) {
        return this.cdf((int)d);
    }

    public abstract double cdf(int var1);

    public double barF(double d) {
        return this.barF((int)d);
    }

    public double barF(int n) {
        return 1.0 - this.cdf(n - 1);
    }

    public double inverseF(double d) {
        return this.inverseFInt(d);
    }

    public int inverseFInt(double d) {
        int n;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d <= this.cdf[this.xmed - this.xmin]) {
            if (d <= this.cdf[0]) {
                return this.xmin;
            }
            n = 0;
            int n2 = this.xmed - this.xmin;
            while (n < n2) {
                int n3 = (n + n2) / 2;
                if (d > this.cdf[n3]) {
                    n = n3 + 1;
                    continue;
                }
                n2 = n3;
            }
        } else {
            if ((d = 1.0 - d) < this.cdf[this.xmax - this.xmin]) {
                return this.xmax;
            }
            n = this.xmed - this.xmin + 1;
            int n4 = this.xmax - this.xmin;
            while (n < n4) {
                int n5 = (n + n4) / 2;
                if (d < this.cdf[n5]) {
                    n = n5 + 1;
                    continue;
                }
                n4 = n5;
            }
            --n;
        }
        return n + this.xmin;
    }
}

