/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ChiSquareDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class ChiSquareDistQuick
extends ChiSquareDist {
    public ChiSquareDistQuick(int n) {
        super(n);
    }

    public double inverseF(double d) {
        return ChiSquareDistQuick.inverseF(this.n, d);
    }

    public static double inverseF(int n, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (n == 1) {
            double d2 = NormalDist.inverseF01((1.0 + d) / 2.0);
            return d2 * d2;
        }
        if (n == 2) {
            double d3 = 1.0 - d;
            if (d3 < 1.0E-16) {
                d3 = 1.0E-16;
            }
            return -Math.log(d3) * 2.0;
        }
        if (d > 0.02 && d < 0.98) {
            double d4 = NormalDist.inverseF01(d);
            double d5 = Math.sqrt(n);
            double d6 = d4 * d4;
            double d7 = -(((3753.0 * d6 + 4353.0) * d6 - 289517.0) * d6 - 289717.0) * d4 * 0.7071067811865476 / 9185400.0;
            d7 = d7 / d5 + (((12.0 * d6 - 243.0) * d6 - 923.0) * d6 + 1472.0) / 25515.0;
            d7 = d7 / d5 + ((9.0 * d6 + 256.0) * d6 - 433.0) * d4 * 0.7071067811865476 / 4860.0;
            d7 = d7 / d5 - ((6.0 * d6 + 14.0) * d6 - 32.0) / 405.0;
            d7 = d7 / d5 + (d6 - 7.0) * d4 * 0.7071067811865476 / 9.0;
            d7 = d7 / d5 + 2.0 * (d6 - 1.0) / 3.0;
            d7 = d7 / d5 + d4 / 0.7071067811865476;
            return (double)n * (d7 / d5 + 1.0);
        }
        if (n >= 10) {
            double d8 = NormalDist.inverseF01(d);
            double d9 = d8 * d8;
            double d10 = 0.3333333333333333 + (-d9 + 3.0) / (162.0 * (double)n) - (3.0 * d9 * d9 + 40.0 * d9 + 45.0) / (5832.0 * (double)n * (double)n) + (301.0 * d9 * d9 * d9 - 1519.0 * d9 * d9 - 32769.0 * d9 - 79349.0) / (7873200.0 * (double)n * (double)n * (double)n);
            double d11 = 1.0 - 2.0 / (9.0 * (double)n) + (4.0 * d9 * d9 + 16.0 * d9 - 28.0) / (1215.0 * (double)n * (double)n) + (8.0 * d9 * d9 * d9 + 720.0 * d9 * d9 + 3216.0 * d9 + 2904.0) / (229635.0 * (double)n * (double)n * (double)n) + (d10 *= d8 * Math.sqrt(2.0 / (double)n));
            return (double)n * d11 * d11 * d11;
        }
        return 2.0 * GammaDist.inverseF((double)n / 2.0, 6, d);
    }
}

