/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Lmder_fcn;
import optimization.Minpack_f77;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;

public class BetaDist
extends ContinuousDistribution {
    private static final double RENORM = 1.0E300;
    protected double alpha;
    protected double beta;
    protected double a;
    protected double b;
    protected double bminusa;
    protected double logFactor;
    protected double Beta;
    protected double logBeta;

    public BetaDist(double d, double d2) {
        this.setParams(d, d2, 0.0, 1.0, this.decPrec);
    }

    public BetaDist(double d, double d2, double d3, double d4) {
        this.setParams(d, d2, d3, d4, this.decPrec);
    }

    public BetaDist(double d, double d2, int n) {
        this.setParams(d, d2, 0.0, 1.0, n);
    }

    public BetaDist(double d, double d2, double d3, double d4, int n) {
        this.setParams(d, d2, d3, d4, n);
    }

    public double density(double d) {
        if (d <= this.a || d >= this.b) {
            return 0.0;
        }
        double d2 = (this.alpha - 1.0) * Math.log(d - this.a) + (this.beta - 1.0) * Math.log(this.b - d);
        return Math.exp(this.logFactor + d2);
    }

    public double cdf(double d) {
        if (this.a >= this.b) {
            throw new IllegalArgumentException("a >= b");
        }
        return BetaDist.cdf(this.alpha, this.beta, this.decPrec, (d - this.a) / this.bminusa);
    }

    public double inverseF(double d) {
        return this.a + (this.b - this.a) * BetaDist.inverseF(this.alpha, this.beta, this.decPrec, d);
    }

    public double getMean() {
        return BetaDist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return BetaDist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return BetaDist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double d, double d2, double d3) {
        return BetaDist.density(d, d2, 0.0, 1.0, d3);
    }

    public static double density(double d, double d2, double d3, double d4, double d5) {
        if (d3 >= d4) {
            throw new IllegalArgumentException("a >= b");
        }
        if (d5 <= d3 || d5 >= d4) {
            return 0.0;
        }
        double d6 = Num.lnGamma(d + d2) - (Num.lnGamma(d) + Num.lnGamma(d2)) - (d + d2 - 1.0) * Math.log(d4 - d3) + (d - 1.0) * Math.log(d5 - d3) + (d2 - 1.0) * Math.log(d4 - d5);
        return Math.exp(d6);
    }

    private static double isubx_alphabeta_small(double d, double d2, double d3, int n) {
        double d4;
        int n2 = 0;
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("alpha not in (0, 1] ");
        }
        if (d2 <= 0.0 || d2 > 2.0) {
            throw new IllegalArgumentException("beta not in (0, 2] ");
        }
        double d5 = EPSARRAY[n];
        double d6 = Math.pow(d3, d);
        double d7 = d6 / d;
        do {
            d6 = ((double)(n2 + 1) - d2) * d3 * d6 / (double)(n2 + 1);
            d4 = d6 / ((double)(n2 + 1) + d);
            ++n2;
        } while (Math.abs(d4) / (d7 += d4) > d5);
        d4 = Num.lnGamma(d + d2) - Num.lnGamma(d) - Num.lnGamma(d2);
        return d7 * Math.exp(d4);
    }

    private static void forward(double d, double d2, double d3, double d4, double d5, int n, double[] dArray) {
        dArray[0] = d4;
        if (n > 0) {
            dArray[1] = d5;
        }
        for (int i = 1; i < n; ++i) {
            dArray[i + 1] = (1.0 + ((double)(i - 1) + d + d2) * (1.0 - d3) / ((double)i + d2)) * dArray[i] - ((double)(i - 1) + d + d2) * (1.0 - d3) * dArray[i - 1] / ((double)i + d2);
        }
    }

    private static void backward(double d, double d2, double d3, double d4, int n, int n2, double[] dArray) {
        boolean bl;
        int n3;
        int n4;
        dArray[0] = d4;
        if (n2 == 0) {
            return;
        }
        double d5 = EPSARRAY[n];
        int n5 = 2 * n2 + 5;
        for (n4 = 64; n4 <= n5; n4 *= 2) {
        }
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        for (n3 = 1; n3 <= n2; ++n3) {
            dArray3[n3] = 0.0;
        }
        for (n3 = 0; n3 <= n2; ++n3) {
            dArray4[n3] = dArray[n3];
        }
        block3: do {
            n3 = n5;
            double d6 = 0.0;
            do {
                d6 = ((double)(n3 - 1) + d + d2) * d3 / ((double)n3 + d + ((double)(n3 - 1) + d + d2) * d3 - ((double)n3 + d) * d6);
                if (n3 > n2) continue;
                dArray2[n3 - 1] = d6;
            } while (--n3 >= 1);
            for (n3 = 0; n3 < n2; ++n3) {
                dArray4[n3 + 1] = dArray2[n3] * dArray4[n3];
            }
            bl = false;
            for (n3 = 1; n3 <= n2; ++n3) {
                if (!(Math.abs((dArray4[n3] - dArray3[n3]) / dArray4[n3]) > d5)) continue;
                bl = true;
                for (int i = 1; i <= n2; ++i) {
                    dArray3[i] = dArray4[i];
                }
                if (n4 > (n5 += 5)) continue block3;
                double[] dArray5 = new double[n4 *= 2];
                System.arraycopy(dArray2, 0, dArray5, 0, dArray2.length);
                dArray2 = dArray5;
                dArray5 = new double[n4];
                System.arraycopy(dArray3, 0, dArray5, 0, dArray3.length);
                dArray3 = dArray5;
                dArray5 = new double[n4];
                System.arraycopy(dArray4, 0, dArray5, 0, dArray4.length);
                dArray4 = dArray5;
                continue block3;
            }
        } while (bl);
        for (n3 = 0; n3 <= n2; ++n3) {
            dArray[n3] = dArray4[n3];
        }
    }

    private static void isubx_beta_fixed(double d, double d2, double d3, int n, int n2, double[] dArray) {
        int n3;
        double d4;
        double d5 = 0.0;
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("alpha not in (0, 1] ");
        }
        int n4 = (int)d2;
        double d6 = d2 - (double)n4;
        if (d6 > 0.0) {
            d4 = d6;
            n3 = n4;
        } else {
            d4 = d6 + 1.0;
            n3 = n4 - 1;
        }
        double d7 = 1.0E300 * BetaDist.isubx_alphabeta_small(d, d4, d3, n);
        if (n3 > 0) {
            d5 = 1.0E300 * BetaDist.isubx_alphabeta_small(d, d4 + 1.0, d3, n);
        }
        double[] dArray2 = new double[n3 + 1];
        BetaDist.forward(d, d4, d3, d7, d5, n3, dArray2);
        BetaDist.backward(d, d2, d3, dArray2[n3], n, n2, dArray);
        n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] / 1.0E300;
        }
    }

    private static void isubx_alpha_fixed(double d, double d2, double d3, int n, int n2, double[] dArray) {
        int n3;
        double d4;
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("beta not in (0, 1] ");
        }
        int n4 = (int)d;
        double d5 = d - (double)n4;
        if (d5 > 0.0) {
            d4 = d5;
            n3 = n4;
        } else {
            d4 = d5 + 1.0;
            n3 = n4 - 1;
        }
        double d6 = 1.0E300 * BetaDist.isubx_alphabeta_small(d4, d2, d3, n);
        double d7 = 1.0E300 * BetaDist.isubx_alphabeta_small(d4, d2 + 1.0, d3, n);
        double[] dArray2 = new double[n3 + 1];
        BetaDist.backward(d4, d2, d3, d6, n, n3, dArray2);
        double d8 = dArray2[n3];
        BetaDist.backward(d4, d2 + 1.0, d3, d7, n, n3, dArray2);
        double d9 = dArray2[n3];
        BetaDist.forward(d, d2, d3, d8, d9, n2, dArray);
        n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] / 1.0E300;
        }
    }

    private static void beta_beta_fixed(double d, double d2, double d3, int n, int n2, double[] dArray) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("alpha not in (0, 1]");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("nmax < 0");
        }
        if (d3 == 0.0 || d3 == 1.0) {
            for (int i = 0; i <= n2; ++i) {
                dArray[i] = d3;
            }
            return;
        }
        if (d3 <= 0.5) {
            BetaDist.isubx_beta_fixed(d, d2, d3, n, n2, dArray);
        } else {
            BetaDist.isubx_alpha_fixed(d2, d, 1.0 - d3, n, n2, dArray);
            for (int i = 0; i <= n2; ++i) {
                dArray[i] = 1.0 - dArray[i];
            }
        }
    }

    private static void beta_alpha_fixed(double d, double d2, double d3, int n, int n2, double[] dArray) {
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("beta not in (0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("nmax < 0");
        }
        if (d3 == 0.0 || d3 == 1.0) {
            for (int i = 0; i <= n2; ++i) {
                dArray[i] = d3;
            }
            return;
        }
        if (d3 <= 0.5) {
            BetaDist.isubx_alpha_fixed(d, d2, d3, n, n2, dArray);
        } else {
            BetaDist.isubx_beta_fixed(d2, d, 1.0 - d3, n, n2, dArray);
            for (int i = 0; i <= n2; ++i) {
                dArray[i] = 1.0 - dArray[i];
            }
        }
    }

    private static double beta_g(double d, int n) {
        double d2;
        if (d > 1.3) {
            return -BetaDist.beta_g(1.0 / d, n);
        }
        if (d < 1.0E-20) {
            return 1.0;
        }
        if (d < 0.7) {
            return (1.0 - d * d + 2.0 * d * Math.log(d)) / ((1.0 - d) * (1.0 - d));
        }
        if (d == 1.0) {
            return 0.0;
        }
        double d3 = EPSARRAY[n];
        double d4 = 1.0 - d;
        double d5 = 0.0;
        double d6 = 1.0;
        int n2 = 2;
        do {
            d2 = (d6 *= d4) / (double)(n2 * (n2 + 1));
            ++n2;
        } while (Math.abs(d2 / (d5 += d2)) > d3);
        return 2.0 * d5;
    }

    public static double cdf(double d, double d2, int n, double d3) {
        boolean bl = false;
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        if (d3 >= 1.0) {
            return 1.0;
        }
        if (Math.max(d, d2) <= 1000.0) {
            if (d < d2) {
                int n2 = (int)d;
                double d4 = d - (double)n2;
                if (d4 <= 0.0) {
                    d4 = 1.0;
                    --n2;
                }
                double[] dArray = new double[n2 + 1];
                BetaDist.beta_beta_fixed(d4, d2, d3, n, n2, dArray);
                double d5 = dArray[n2];
                if (d5 <= 0.0) {
                    return 0.0;
                }
                if (d5 <= 1.0) {
                    return d5;
                }
                return 1.0;
            }
            int n3 = (int)d2;
            double d6 = d2 - (double)n3;
            if (d6 <= 0.0) {
                d6 = 1.0;
                --n3;
            }
            double[] dArray = new double[n3 + 1];
            BetaDist.beta_alpha_fixed(d, d6, d3, n, n3, dArray);
            double d7 = dArray[n3];
            if (d7 <= 0.0) {
                return 0.0;
            }
            if (d7 <= 1.0) {
                return d7;
            }
            return 1.0;
        }
        if (d > 1000.0 && d2 < 30.0 || d2 > 1000.0 && d < 30.0) {
            double d8;
            if (d3 > 0.5) {
                return 1.0 - BetaDist.cdf(d2, d, n, 1.0 - d3);
            }
            if (d < d2) {
                d8 = d;
                d = d2;
                d2 = d8;
                bl = false;
            } else {
                bl = true;
            }
            d8 = d + 0.5 * d2 - 0.5;
            double d9 = !bl ? d3 / (2.0 - d3) : (1.0 - d3) / (1.0 + d3);
            double d10 = 2.0 * d8 * d9;
            double d11 = Math.exp(d2 * Math.log(d10) - d10 - Num.lnGamma(d2)) * (2.0 * d10 * d10 - (d2 - 1.0) * d10 - (d2 * d2 - 1.0)) / (24.0 * d8 * d8);
            if (bl) {
                d10 = GammaDist.barF(d2, n, d10);
                return d10 - d11;
            }
            d10 = GammaDist.cdf(d2, n, d10);
            return d10 + d11;
        }
        double d12 = d + d2 - 1.0;
        double d13 = 1.0 - d3;
        double d14 = Math.sqrt((1.0 + d13 * BetaDist.beta_g((d - 0.5) / (d12 * d3), n) + d3 * BetaDist.beta_g((d2 - 0.5) / (d12 * d13), n)) / ((d12 + 0.16666666666666666) * d3 * d13)) * ((d12 + 0.3333333333333333 + 0.02 * (1.0 / d + 1.0 / d2 + 1.0 / (d + d2))) * d3 - d + 0.3333333333333333 - 0.02 / d - 0.01 / (d + d2));
        return NormalDist.cdf01(d14);
    }

    public static double cdf(double d, double d2, double d3, double d4, int n, double d5) {
        return BetaDist.cdf(d, d2, n, (d5 - d3) / (d4 - d3));
    }

    public static double barF(double d, double d2, int n, double d3) {
        return 1.0 - BetaDist.cdf(d, d2, n, d3);
    }

    public static double barF(double d, double d2, double d3, double d4, int n, double d5) {
        if (d3 >= d4) {
            throw new IllegalArgumentException("a >= b");
        }
        return 1.0 - BetaDist.cdf(d, d2, n, (d5 - d3) / (d4 - d3));
    }

    public static double inverseF(double d, double d2, int n, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d3 > 1.0 || d3 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        if (d3 >= 1.0) {
            return 1.0;
        }
        boolean bl = false;
        boolean bl2 = false;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 1.0;
        double d18 = 1.0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (d <= 1.0 || d2 <= 1.0) {
            d13 = 1.0E-6;
            bl4 = false;
            d4 = d;
            d5 = d2;
            d6 = d3;
            d9 = d4 / (d4 + d5);
            d8 = BetaDist.cdf(d4, d5, n, d9);
            bl = true;
        } else {
            d13 = 1.0E-4;
        }
        block0: while (true) {
            int n2;
            if (bl) {
                bl = false;
                int n3 = 0;
                d12 = 0.5;
                for (n2 = 0; n2 < 100; ++n2) {
                    if (n2 != 0) {
                        d9 = d15 + d12 * (d17 - d15);
                        if (d9 == 1.0) {
                            d9 = 0.9999999999999999;
                        }
                        if (d9 == 0.0 && (d9 = d15 + (d12 = 0.5) * (d17 - d15)) == 0.0) {
                            System.err.println("BetaDist.inverseF: underflow");
                            return 0.0;
                        }
                        d8 = BetaDist.cdf(d4, d5, n, d9);
                        d11 = (d17 - d15) / (d17 + d15);
                        if (Math.abs(d11) < d13) {
                            bl2 = true;
                            continue block0;
                        }
                        d11 = (d8 - d6) / d6;
                        if (Math.abs(d11) < d13) {
                            bl2 = true;
                            continue block0;
                        }
                    }
                    if (d8 < d6) {
                        d15 = d9;
                        d16 = d8;
                        if (n3 < 0) {
                            n3 = 0;
                            d12 = 0.5;
                        } else {
                            d12 = n3 > 3 ? 1.0 - (1.0 - d12) * (1.0 - d12) : (n3 > 1 ? 0.5 * d12 + 0.5 : (d6 - d8) / (d18 - d16));
                        }
                        ++n3;
                        if (!(d15 > 0.75)) continue;
                        if (bl4) {
                            bl4 = false;
                            d4 = d;
                            d5 = d2;
                            d6 = d3;
                        } else {
                            bl4 = true;
                            d4 = d2;
                            d5 = d;
                            d6 = 1.0 - d3;
                        }
                        d9 = 1.0 - d9;
                        d8 = BetaDist.cdf(d4, d5, n, d9);
                        d15 = 0.0;
                        d16 = 0.0;
                        d17 = 1.0;
                        d18 = 1.0;
                        bl = true;
                        continue block0;
                    }
                    d17 = d9;
                    if (bl4 && d17 < (double)1.110223E-16f) {
                        d9 = 0.0;
                        break block0;
                    }
                    d18 = d8;
                    if (n3 > 0) {
                        n3 = 0;
                        d12 = 0.5;
                    } else {
                        d12 = n3 < -3 ? (d12 *= d12) : (n3 < -1 ? 0.5 * d12 : (d8 - d6) / (d18 - d16));
                    }
                    --n3;
                }
                if (d15 >= 1.0) {
                    d9 = 0.9999999999999999;
                    break;
                }
                if (d9 <= 0.0) {
                    System.err.println("BetaDist.inverseF: underflow");
                    return 0.0;
                }
                bl2 = true;
            }
            if (bl2) {
                bl2 = false;
                if (bl3) break;
                bl3 = true;
                d10 = Num.lnGamma(d4 + d5) - Num.lnGamma(d4) - Num.lnGamma(d5);
                for (n2 = 0; n2 < 8; ++n2) {
                    if (n2 != 0) {
                        d8 = BetaDist.cdf(d4, d5, n, d9);
                    }
                    if (d8 < d16) {
                        d9 = d15;
                        d8 = d16;
                    } else if (d8 > d18) {
                        d9 = d17;
                        d8 = d18;
                    } else if (d8 < d6) {
                        d15 = d9;
                        d16 = d8;
                    } else {
                        d17 = d9;
                        d18 = d8;
                    }
                    if (d9 >= 1.0 || d9 <= 0.0) break;
                    d7 = (d4 - 1.0) * Math.log(d9) + (d5 - 1.0) * Num.log1p(-d9) + d10;
                    if (d7 < -708.3964185322641) break block0;
                    if (d7 > 709.782712893384) break;
                    d7 = Math.exp(d7);
                    d14 = d9 - (d7 = (d8 - d6) / d7);
                    if (d14 <= d15 && (d14 = d15 + 0.5 * (d8 = (d9 - d15) / (d17 - d15)) * (d9 - d15)) <= 0.0 || d14 >= d17 && (d14 = d17 - 0.5 * (d8 = (d17 - d9) / (d17 - d15)) * (d17 - d9)) >= 1.0) break;
                    d9 = d14;
                    if (Math.abs(d7 / d9) < 1.4210854715202004E-14) break block0;
                }
                d13 = 2.842170943040401E-14;
                bl = true;
                continue;
            }
            d11 = -NormalDist.inverseF01(d3);
            if (d3 > 0.5) {
                bl4 = true;
                d4 = d2;
                d5 = d;
                d6 = 1.0 - d3;
                d11 = -d11;
            } else {
                bl4 = false;
                d4 = d;
                d5 = d2;
                d6 = d3;
            }
            d10 = (d11 * d11 - 3.0) / 6.0;
            d9 = 2.0 / (1.0 / (2.0 * d4 - 1.0) + 1.0 / (2.0 * d5 - 1.0));
            d7 = d11 * Math.sqrt(d9 + d10) / d9 - (1.0 / (2.0 * d5 - 1.0) - 1.0 / (2.0 * d4 - 1.0)) * (d10 + 0.8333333333333334 - 2.0 / (3.0 * d9));
            d7 = 2.0 * d7;
            if (d7 < -708.3964185322641) {
                d9 = 1.0;
                System.err.println("BetaDist.inverseF: underflow");
                return 0.0;
            }
            d9 = d4 / (d4 + d5 * Math.exp(d7));
            d8 = BetaDist.cdf(d4, d5, n, d9);
            d11 = (d8 - d6) / d6;
            if (Math.abs(d11) < 0.2) {
                bl2 = true;
                continue;
            }
            bl = true;
        }
        if (bl4) {
            d9 = d9 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d9;
        }
        return d9;
    }

    public static double inverseF(double d, double d2, double d3, double d4, int n, double d5) {
        if (d3 >= d4) {
            throw new IllegalArgumentException("a >= b");
        }
        return d3 + (d4 - d3) * BetaDist.inverseF(d, d2, n, d5);
    }

    public static BetaDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = BetaDist.getMaximumLikelihoodEstimate(dArray, n);
        return new BetaDist(dArray2[0], dArray2[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
            d2 += Math.log(dArray[i]);
            d3 += Math.log(1.0 - dArray[i]);
        }
        double d4 = d / (double)n;
        d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (dArray[i] - d4) * (dArray[i] - d4);
        }
        double d5 = d / ((double)n - 1.0);
        Optim optim = new Optim(d2, d3);
        double[] dArray2 = new double[3];
        dArray2[1] = d4 * (d4 * (1.0 - d4) / d5 - 1.0);
        dArray2[2] = (1.0 - d4) * (d4 * (1.0 - d4) / d5 - 1.0);
        double[] dArray3 = new double[3];
        double[][] dArray4 = new double[3][3];
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[3];
        Minpack_f77.lmder1_f77((Lmder_fcn)optim, (int)2, (int)2, (double[])dArray2, (double[])dArray3, (double[][])dArray4, (double)1.0E-5, (int[])nArray2, (int[])nArray3);
        double[] dArray5 = new double[]{dArray2[1], dArray2[2]};
        return dArray5;
    }

    public static double getMean(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d / (d + d2);
    }

    public static double getVariance(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d * d2 / ((d + d2) * (d + d2) * (d + d2 + 1.0));
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(BetaDist.getVariance(d, d2));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public void setParams(double d, double d2, double d3, double d4, int n) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 >= d4) {
            throw new IllegalArgumentException("a >= b");
        }
        this.alpha = d;
        this.beta = d2;
        this.decPrec = n;
        this.supportA = this.a = d3;
        this.supportB = this.b = d4;
        this.bminusa = d4 - d3;
        double d5 = Num.lnGamma(d);
        d5 = d == d2 ? (d5 *= 2.0) : (d5 += Num.lnGamma(d2));
        this.logBeta = d5 - Num.lnGamma(d + d2);
        this.Beta = Math.exp(this.logBeta);
        this.logFactor = -this.logBeta - Math.log(this.bminusa) * (d + d2 - 1.0);
    }

    private static class Optim
    implements Lmder_fcn {
        private double a;
        private double b;

        public Optim(double d, double d2) {
            this.a = d;
            this.b = d2;
        }

        public void fcn(int n, int n2, double[] dArray, double[] dArray2, double[][] dArray3, int[] nArray) {
            if (nArray[1] == 1) {
                double d = Num.digamma(dArray[1] + dArray[2]);
                dArray2[1] = Num.digamma(dArray[1]) - d - this.a;
                dArray2[2] = Num.digamma(dArray[2]) - d - this.b;
            } else if (nArray[1] == 2) {
                double d = Num.trigamma(dArray[1] + dArray[2]);
                dArray3[1][1] = Num.trigamma(dArray[1]) - d;
                dArray3[1][2] = -d;
                dArray3[2][1] = -d;
                dArray3[2][2] = Num.trigamma(dArray[2]) - d;
            }
        }
    }
}

