/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.markovchain;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.markovchain.MarkovChainDouble;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.Tally;

public abstract class MarkovChainDoubleStop
extends MarkovChainDouble {
    public double getPerformance() {
        return this.getPerformance(this.numSteps);
    }

    public double simulStepsDouble(int n, RandomStream randomStream) {
        this.state = this.initialStateDouble();
        this.initStats();
        this.numSteps = n;
        for (int i = 0; i < n && this.state < Double.POSITIVE_INFINITY; ++i) {
            this.state = this.nextStepDouble(i, this.state, randomStream);
        }
        return this.state;
    }

    public void simulSteps(int n, RandomStream randomStream) {
        this.simulStepsDouble(n, randomStream);
    }

    public void simulSteps(RandomStream randomStream) {
        this.simulStepsDouble(Integer.MAX_VALUE, randomStream);
    }

    public void simulRQMC(PointSet pointSet, int n, int n2, RandomStream randomStream, Tally tally) {
        tally.init();
        Tally tally2 = new Tally();
        int n3 = pointSet.getNumPoints();
        PointSetIterator pointSetIterator = pointSet.iterator();
        for (int i = 1; i < n; ++i) {
            pointSet.randomize(randomStream);
            this.simulRunsWithSubstreams(n3, n2, pointSetIterator, tally2);
            tally.add(tally2.average());
        }
    }
}

