/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.markovchain;

import java.util.Arrays;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.markovchain.ArrayOfComparableChains;
import umontreal.iro.lecuyer.markovchain.MarkovChainDouble;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ArrayOfDoubleChains
extends ArrayOfComparableChains {
    protected MarkovChainDouble baseChain;
    protected double[] state;

    public ArrayOfDoubleChains(MarkovChainDouble markovChainDouble) {
        super(markovChainDouble);
        this.baseChain = markovChainDouble;
    }

    public void makeCopies(int n) {
        this.state = new double[n];
        this.n = n;
    }

    public double simulArrayRQMC(PointSet pointSet, int n, RandomStream randomStream) {
        int n2;
        PointSetIterator pointSetIterator = pointSet.iterator();
        this.baseChain.initStats();
        for (n2 = 0; n2 < this.n; ++n2) {
            this.state[n2] = this.baseChain.initialStateDouble();
        }
        for (n2 = 0; n2 < n; ++n2) {
            Arrays.sort(this.state);
            pointSet.randomize(randomStream);
            randomStream.resetNextSubstream();
            pointSetIterator.resetStartStream();
            for (int i = 0; i < this.n; ++i) {
                this.state[i] = this.baseChain.nextStepDouble(n2, this.state[i], pointSetIterator);
                pointSetIterator.resetNextSubstream();
            }
        }
        return this.baseChain.getPerformance(n) / (double)this.n;
    }
}

