/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.markovchain;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.markovchain.MarkovChainComparable;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.Chrono;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class ArrayOfComparableChains {
    protected MarkovChainComparable baseChain;
    protected int n;
    protected AbstractList chains;

    public ArrayOfComparableChains(MarkovChainComparable markovChainComparable) {
        this.baseChain = markovChainComparable;
    }

    public void makeCopies(int n) {
        this.chains = new ArrayList(n);
        this.n = n;
        for (int i = 0; i < n; ++i) {
            try {
                this.chains.add((MarkovChainComparable)this.baseChain.clone());
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.err.println("ArrayOfComparableChains:");
                cloneNotSupportedException.printStackTrace();
            }
        }
    }

    public double simulArrayRQMC(PointSet pointSet, int n, RandomStream randomStream) {
        MarkovChainComparable markovChainComparable;
        int n2;
        PointSetIterator pointSetIterator = pointSet.iterator();
        double d = 0.0;
        for (n2 = 0; n2 < this.n; ++n2) {
            markovChainComparable = (MarkovChainComparable)this.chains.get(n2);
            markovChainComparable.initialState();
        }
        for (n2 = 0; n2 < n; ++n2) {
            Collections.sort(this.chains);
            pointSet.randomize(randomStream);
            randomStream.resetNextSubstream();
            pointSetIterator.resetStartStream();
            for (int i = 0; i < this.n; ++i) {
                markovChainComparable = (MarkovChainComparable)this.chains.get(i);
                markovChainComparable.nextStep(pointSetIterator);
                pointSetIterator.resetNextSubstream();
            }
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            markovChainComparable = (MarkovChainComparable)this.chains.get(n2);
            d += markovChainComparable.getPerformance();
        }
        return d / (double)this.n;
    }

    public String simulReplicatesArrayRQMC(PointSet pointSet, int n, int n2, RandomStream randomStream, Tally tally) {
        Chrono chrono = Chrono.createForSingleThread();
        this.makeCopies(pointSet.getNumPoints());
        chrono.init();
        tally.init();
        for (int i = 0; i < n; ++i) {
            tally.add(this.simulArrayRQMC(pointSet, n2, randomStream));
        }
        StringBuffer stringBuffer = new StringBuffer("----------------------------------------------\n");
        stringBuffer.append("Array-RQMC simulations:\n");
        stringBuffer.append("\n" + pointSet.toString() + ":\n");
        stringBuffer.append(" Number of indep copies m  = " + n);
        stringBuffer.append("\n Number of points n        = " + this.n + "\n");
        stringBuffer.append(this.baseChain.formatResultsRQMC(tally, this.n));
        stringBuffer.append(" CPU Time = " + chrono.format() + "\n");
        return stringBuffer.toString();
    }

    public String simulReplicatesArrayRQMC2(PointSet pointSet, int n, int n2, PointSet pointSet2, RandomStream randomStream, Tally tally) {
        Chrono chrono = Chrono.createForSingleThread();
        this.makeCopies(pointSet.getNumPoints());
        chrono.init();
        tally.init();
        for (int i = 0; i < n; ++i) {
            pointSet2.randomize(randomStream);
            PointSetIterator pointSetIterator = pointSet2.iterator();
            tally.add(this.simulArrayRQMC(pointSet, n2, pointSetIterator));
        }
        StringBuffer stringBuffer = new StringBuffer("----------------------------------------------\n");
        stringBuffer.append("Array-RQMC2 simulations:\n");
        stringBuffer.append("\n" + pointSet.toString() + ":\n");
        stringBuffer.append(" Number of indep copies m  = " + n);
        stringBuffer.append("\n Number of points n        = " + this.n + "\n");
        stringBuffer.append(this.baseChain.formatResultsRQMC(tally, this.n));
        stringBuffer.append(" CPU Time = " + chrono.format() + "\n");
        return stringBuffer.toString();
    }

    public String testImprovementArrayRQMC(PointSet pointSet, int n, int n2, RandomStream randomStream, double d, Tally tally) {
        StringBuffer stringBuffer = new StringBuffer(this.simulReplicatesArrayRQMC(pointSet, n, n2, randomStream, tally));
        double d2 = (double)pointSet.getNumPoints() * tally.variance();
        stringBuffer.append(" Variance ratio: " + PrintfFormat.format(15, 10, 4, d / d2) + "\n");
        return stringBuffer.toString();
    }

    public String testImprovementArrayRQMC2(PointSet pointSet, int n, int n2, PointSet pointSet2, RandomStream randomStream, double d, Tally tally) {
        StringBuffer stringBuffer = new StringBuffer(this.simulReplicatesArrayRQMC2(pointSet, n, n2, pointSet2, randomStream, tally));
        double d2 = (double)pointSet.getNumPoints() * tally.variance();
        stringBuffer.append(" Variance ratio: " + PrintfFormat.format(15, 10, 4, d / d2) + "\n");
        return stringBuffer.toString();
    }
}

