/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;

public class PaddedPointSet
extends PointSet {
    protected int curPointSets = 0;
    protected int maxPointSets;
    protected PointSet[] pointSet;
    protected int[] startDim;
    protected int[][] permutation;

    public PaddedPointSet(int n) {
        this.maxPointSets = n;
        this.pointSet = new PointSet[n];
        this.startDim = new int[n];
        this.permutation = new int[n][];
    }

    public void padPointSet(PointSet pointSet) {
        if (this.curPointSets == this.maxPointSets) {
            throw new IllegalArgumentException("Cannot pad more, increase maxPointSets parameter");
        }
        if (this.dim == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot pad more, dimension already infinite");
        }
        if (this.curPointSets > 0 && this.numPoints != pointSet.getNumPoints()) {
            throw new IllegalArgumentException("Padded points must have same number of points");
        }
        if (this.curPointSets == 0) {
            this.numPoints = pointSet.getNumPoints();
        }
        this.dim = pointSet.getDimension() == Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.dim += pointSet.getDimension());
        this.pointSet[this.curPointSets] = pointSet;
        this.startDim[this.curPointSets] = this.dim;
        ++this.curPointSets;
    }

    public void padPointSetPermute(PointSet pointSet) {
        if (this.curPointSets == 0) {
            this.numPoints = pointSet.getNumPoints();
        }
        if (this.numPoints == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot generate infinite permutation");
        }
        this.permutation[this.curPointSets] = new int[this.numPoints];
        for (int i = 0; i < this.numPoints; ++i) {
            this.permutation[this.curPointSets][i] = i;
        }
        this.padPointSet(pointSet);
    }

    public double getCoordinate(int n, int n2) {
        int n3 = 0;
        if (n2 >= this.dim) {
            throw new IllegalArgumentException("Not enough dimensions");
        }
        while (n2 >= this.startDim[n3]) {
            ++n3;
        }
        if (this.permutation[n3] != null) {
            n = this.permutation[n3][n];
        }
        if (n3 != 0) {
            n2 -= this.startDim[n3 - 1];
        }
        return this.pointSet[n3].getCoordinate(n, n2);
    }

    public void unrandomize() {
        for (int i = 0; i < this.curPointSets; ++i) {
            if (this.permutation[i] == null) continue;
            for (int j = 0; j < this.numPoints; ++j) {
                this.permutation[i][j] = j;
            }
        }
    }

    public void randomize(RandomStream randomStream) {
        super.randomize(randomStream);
        for (int i = 0; i < this.curPointSets; ++i) {
            if (this.permutation[i] == null) continue;
            for (int j = 0; j < this.numPoints - 1; ++j) {
                int n = randomStream.nextInt(0, this.numPoints - j - 1);
                int n2 = this.permutation[i][j];
                this.permutation[i][j] = this.permutation[i][j + n];
                this.permutation[i][j + n] = n2;
            }
        }
    }

    public PointSetIterator iterator() {
        return new PaddedIterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Padded point set\n");
        stringBuffer.append("Maximal number of point sets: " + this.maxPointSets + "\n");
        stringBuffer.append("Current number of point sets: " + this.curPointSets + "\n");
        stringBuffer.append("Number of points: " + this.numPoints + "\n");
        for (int i = 0; i < this.curPointSets; ++i) {
            if (i != 0) {
                stringBuffer.append("\n");
            }
            if (this.permutation[i] == null) {
                stringBuffer.append("Point set ");
            } else {
                stringBuffer.append("Permuted point set ");
            }
            stringBuffer.append("" + i + " information: {\n" + this.pointSet[i].toString() + "\n}");
        }
        return stringBuffer.toString();
    }

    private class PaddedIterator
    extends PointSet.DefaultPointSetIterator {
        private PointSetIterator[] pointSetIterators;
        private int currentSet = 0;
        private double[] temp;

        public PaddedIterator() {
            super(PaddedPointSet.this);
            this.pointSetIterators = new PointSetIterator[PaddedPointSet.this.curPointSets];
            int n = 0;
            for (int i = 0; i < PaddedPointSet.this.curPointSets; ++i) {
                this.pointSetIterators[i] = PaddedPointSet.this.pointSet[i].iterator();
                if (PaddedPointSet.this.pointSet[i].getDimension() > n) {
                    n = PaddedPointSet.this.pointSet[i].getDimension();
                }
                if (PaddedPointSet.this.permutation[i] == null) continue;
                this.pointSetIterators[i].setCurPointIndex(PaddedPointSet.this.permutation[i][0]);
            }
            this.temp = n == Integer.MAX_VALUE ? new double[16] : new double[n];
        }

        public void setCurCoordIndex(int n) {
            int n2 = 0;
            if (n >= PaddedPointSet.this.dim) {
                throw new IllegalArgumentException("Not enough dimensions");
            }
            while (n >= PaddedPointSet.this.startDim[n2]) {
                ++n2;
            }
            this.currentSet = n2;
            this.pointSetIterators[this.currentSet].setCurCoordIndex(n2 == 0 ? n : n - PaddedPointSet.this.startDim[n2 - 1]);
            for (n2 = this.currentSet + 1; n2 < this.pointSetIterators.length; ++n2) {
                this.pointSetIterators[n2].resetCurCoordIndex();
            }
            this.curCoordIndex = n;
        }

        public void resetCurCoordIndex() {
            this.currentSet = 0;
            for (int i = 0; i < this.pointSetIterators.length; ++i) {
                this.pointSetIterators[i].resetCurCoordIndex();
            }
            this.curCoordIndex = 0;
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= PaddedPointSet.this.numPoints || this.curCoordIndex >= PaddedPointSet.this.dim) {
                this.outOfBounds();
            }
            if (this.curCoordIndex >= PaddedPointSet.this.startDim[this.currentSet]) {
                ++this.currentSet;
            }
            double d = this.pointSetIterators[this.currentSet].nextCoordinate();
            ++this.curCoordIndex;
            return d;
        }

        public void nextCoordinates(double[] dArray, int n) {
            if (this.curPointIndex >= PaddedPointSet.this.numPoints || n > PaddedPointSet.this.dim) {
                this.outOfBounds();
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = PaddedPointSet.this.pointSet[this.currentSet].getDimension();
                n3 = n3 == Integer.MAX_VALUE ? n - n2 : (n3 -= this.pointSetIterators[this.currentSet].getCurCoordIndex());
                this.pointSetIterators[this.currentSet].nextCoordinates(this.temp, n3);
                System.arraycopy(this.temp, 0, dArray, n2, n3);
                this.curCoordIndex += n3;
                if ((n2 += n3) >= n) continue;
                ++this.currentSet;
            }
        }

        public void setCurPointIndex(int n) {
            for (int i = 0; i < this.pointSetIterators.length; ++i) {
                this.pointSetIterators[i].setCurPointIndex(PaddedPointSet.this.permutation[i] == null ? n : PaddedPointSet.this.permutation[i][n]);
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.currentSet = 0;
        }

        public void resetCurPointIndex() {
            for (int i = 0; i < this.pointSetIterators.length; ++i) {
                if (PaddedPointSet.this.permutation[i] == null) {
                    this.pointSetIterators[i].resetCurPointIndex();
                    continue;
                }
                this.pointSetIterators[i].setCurPointIndex(PaddedPointSet.this.permutation[i][0]);
            }
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
            this.currentSet = 0;
        }

        public int resetToNextPoint() {
            for (int i = 0; i < this.pointSetIterators.length; ++i) {
                if (PaddedPointSet.this.permutation[i] == null) {
                    this.pointSetIterators[i].resetToNextPoint();
                    continue;
                }
                this.pointSetIterators[i].setCurPointIndex(PaddedPointSet.this.permutation[i][this.curPointIndex + 1]);
            }
            this.currentSet = 0;
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }

        public String formatState() {
            return super.formatState() + "\nCurrent padded set: " + this.currentSet;
        }
    }
}

