/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import umontreal.iro.lecuyer.hups.DigitalNet;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class DigitalNetFromFile
extends DigitalNet {
    private String filename;
    static /* synthetic */ Class class$umontreal$iro$lecuyer$hups$DigitalNetFromFile;

    private void readMatrices(StreamTokenizer streamTokenizer, int n, int n2, int n3) throws IOException, NumberFormatException {
        this.genMat = new int[n3 * n2][n];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4;
                for (n4 = 0; n4 < n; ++n4) {
                    streamTokenizer.nextToken();
                    this.genMat[i * this.numCols + j][n4] = (int)streamTokenizer.nval;
                }
                for (n4 = n; n4 < this.numRows; ++n4) {
                    streamTokenizer.nextToken();
                }
            }
        }
    }

    void readData(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.slashSlashComments(true);
        int n = streamTokenizer.nextToken();
        if (n != -2) {
            throw new NumberFormatException(" readData: cannot read base");
        }
        this.b = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        this.numCols = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        this.numRows = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        this.numPoints = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        this.dim = (int)streamTokenizer.nval;
        if (this.dim < 1) {
            throw new IllegalArgumentException(" dimension dim <= 0");
        }
    }

    static BufferedReader openURL(String string) throws MalformedURLException, IOException {
        try {
            URL uRL = new URL(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            return bufferedReader;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException + "   Invalid URL address:   " + string);
            throw malformedURLException;
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in openURL with " + string);
            throw iOException;
        }
    }

    static BufferedReader openFile(String string) throws IOException {
        try {
            BufferedReader bufferedReader;
            File file = new File(string);
            if (file.exists()) {
                if (file.isDirectory()) {
                    throw new IOException(string + " is a directory");
                }
                bufferedReader = new BufferedReader(new FileReader(string));
            } else {
                String string2 = "umontreal/iro/lecuyer/hups/data/";
                StringBuffer stringBuffer = new StringBuffer(string2);
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == File.separatorChar) {
                        stringBuffer.append('/');
                        continue;
                    }
                    stringBuffer.append(c);
                }
                InputStream inputStream = (class$umontreal$iro$lecuyer$hups$DigitalNetFromFile == null ? (class$umontreal$iro$lecuyer$hups$DigitalNetFromFile = DigitalNetFromFile.class$("umontreal.iro.lecuyer.hups.DigitalNetFromFile")) : class$umontreal$iro$lecuyer$hups$DigitalNetFromFile).getClassLoader().getResourceAsStream(stringBuffer.toString());
                if (inputStream == null) {
                    throw new FileNotFoundException();
                }
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            return bufferedReader;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException + " *** cannot find  " + string);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            System.err.println(iOException + " cannot read from  " + string);
            throw iOException;
        }
    }

    public DigitalNetFromFile(String string, int n, int n2, int n3) throws MalformedURLException, IOException {
        BufferedReader bufferedReader = null;
        StreamTokenizer streamTokenizer = null;
        try {
            bufferedReader = string.startsWith("http:") || string.startsWith("ftp:") ? DigitalNetFromFile.openURL(string) : DigitalNetFromFile.openFile(string);
            streamTokenizer = new StreamTokenizer(bufferedReader);
            this.readData(streamTokenizer);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("   Invalid URL address:   " + string);
            throw malformedURLException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("   Cannot find  " + string);
            throw fileNotFoundException;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("   Cannot read number from " + string);
            throw numberFormatException;
        }
        catch (IOException iOException) {
            System.err.println("   IOException:   " + string);
            throw iOException;
        }
        if (this.b == 2) {
            System.err.println("   base = 2, use DigitalNetBase2FromFile");
            throw new IllegalArgumentException("base = 2, use DigitalNetBase2FromFile");
        }
        if ((double)this.numCols * Math.log(this.b) > 31.0 * Math.log(2.0)) {
            throw new IllegalArgumentException("DigitalNetFromFile:   too many points\n");
        }
        if (n > this.numRows) {
            throw new IllegalArgumentException("DigitalNetFromFile:   One must have   r1 <= Max num rows\n");
        }
        if (n3 > this.dim) {
            throw new IllegalArgumentException("DigitalNetFromFile:   One must have   s1 <= Max dimension\n");
        }
        if (n2 < 0) {
            n = n2 = this.numRows;
            n3 = this.dim;
        }
        if (n2 < this.numRows) {
            throw new IllegalArgumentException("DigitalNetFromFile:   One must have   w >= numRows\n");
        }
        try {
            this.readMatrices(streamTokenizer, n, this.numCols, n3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException + "   cannot read matrices from " + string);
            throw numberFormatException;
        }
        catch (IOException iOException) {
            System.err.println(iOException + "   cannot read matrices from  " + string);
            throw iOException;
        }
        bufferedReader.close();
        this.filename = string;
        this.numRows = n;
        this.dim = n3;
        this.outDigits = n2;
        int n4 = this.b;
        for (int i = 1; i < this.numCols; ++i) {
            n4 *= this.b;
        }
        if (n4 != this.numPoints) {
            System.out.println("DigitalNetFromFile:   numPoints != b^k");
            throw new IllegalArgumentException(" numPoints != b^k");
        }
        this.normFactor = 1.0 / Math.pow(this.b, this.outDigits);
        double d = 1.0 / (double)this.b;
        this.factor = new double[this.outDigits];
        this.factor[0] = d;
        for (int i = 1; i < this.outDigits; ++i) {
            this.factor[i] = this.factor[i - 1] * d;
        }
    }

    public DigitalNetFromFile(String string, int n) throws MalformedURLException, IOException {
        this(string, -1, -1, n);
    }

    DigitalNetFromFile() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("File:   " + this.filename + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public String toStringDetailed() {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        stringBuffer.append("\nn = " + this.numPoints + "\n");
        stringBuffer.append("dim = " + this.dim + "\n");
        for (int i = 0; i < this.dim; ++i) {
            stringBuffer.append("\n // dim = " + (1 + i) + "\n");
            for (int j = 0; j < this.numCols; ++j) {
                for (int k = 0; k < this.numRows; ++k) {
                    stringBuffer.append(this.genMat[i * this.numCols + j][k] + " ");
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private static List getListDir(String string) throws IOException {
        try {
            String string2 = "umontreal/iro/lecuyer/hups/data/";
            StringBuffer stringBuffer = new StringBuffer(string2);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == File.separatorChar) {
                    stringBuffer.append('/');
                    continue;
                }
                stringBuffer.append(c);
            }
            URL uRL = (class$umontreal$iro$lecuyer$hups$DigitalNetFromFile == null ? (class$umontreal$iro$lecuyer$hups$DigitalNetFromFile = DigitalNetFromFile.class$("umontreal.iro.lecuyer.hups.DigitalNetFromFile")) : class$umontreal$iro$lecuyer$hups$DigitalNetFromFile).getClassLoader().getResource(stringBuffer.toString());
            File file = new File(uRL.getPath());
            if (!file.isDirectory()) {
                throw new IllegalArgumentException(string + " is not a directory");
            }
            File[] fileArray = file.listFiles();
            ArrayList<DigitalNetFromFile> arrayList = new ArrayList<DigitalNetFromFile>(200);
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory() || fileArray[i].getName().endsWith("gz") || fileArray[i].getName().endsWith("zip")) continue;
                DigitalNetFromFile digitalNetFromFile = new DigitalNetFromFile();
                BufferedReader bufferedReader = DigitalNetFromFile.openFile(string + fileArray[i].getName());
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                digitalNetFromFile.readData(streamTokenizer);
                digitalNetFromFile.filename = fileArray[i].getName();
                arrayList.add(digitalNetFromFile);
            }
            if (arrayList != null && !fileArray[0].isDirectory()) {
                Collections.sort(arrayList, new NetComparator());
            }
            return arrayList;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("getListDir: cannot find directory   " + string);
            throw nullPointerException;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException + "***   cannot read number ");
            throw numberFormatException;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            throw iOException;
        }
    }

    private static String listFiles(String string) {
        try {
            String string2 = "umontreal/iro/lecuyer/hups/data/";
            StringBuffer stringBuffer = new StringBuffer(string2);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == File.separatorChar) {
                    stringBuffer.append('/');
                    continue;
                }
                stringBuffer.append(c);
            }
            URL uRL = (class$umontreal$iro$lecuyer$hups$DigitalNetFromFile == null ? (class$umontreal$iro$lecuyer$hups$DigitalNetFromFile = DigitalNetFromFile.class$("umontreal.iro.lecuyer.hups.DigitalNetFromFile")) : class$umontreal$iro$lecuyer$hups$DigitalNetFromFile).getClassLoader().getResource(stringBuffer.toString());
            File file = new File(uRL.getPath());
            File[] fileArray = file.listFiles();
            ArrayList arrayList = new ArrayList(200);
            StringBuffer stringBuffer2 = new StringBuffer(1000);
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    stringBuffer2.append(PrintfFormat.s(-2, fileArray[i].getName()));
                    stringBuffer2.append(File.separator + "\n");
                    continue;
                }
                stringBuffer2.append(PrintfFormat.s(-25, fileArray[i].getName()));
                if (i % 3 != 2) continue;
                stringBuffer2.append("\n");
            }
            if (fileArray.length % 3 > 0) {
                stringBuffer2.append("\n");
            }
            return stringBuffer2.toString();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("listFiles: cannot find directory   " + string);
            throw nullPointerException;
        }
    }

    public static String listDir(String string) throws IOException {
        try {
            List list = DigitalNetFromFile.getListDir(string);
            if (list == null || list.size() == 0) {
                return DigitalNetFromFile.listFiles(string);
            }
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append("Directory:   " + string + "\n\n");
            stringBuffer.append(PrintfFormat.s(-25, "     File") + PrintfFormat.s(-15, "       Base") + PrintfFormat.s(-10, "Dimension") + PrintfFormat.s(-10, " numRows") + PrintfFormat.s(-10, "numColumns\n"));
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                DigitalNet digitalNet = (DigitalNet)list.get(i);
                int n2 = ((DigitalNetFromFile)digitalNet).filename.lastIndexOf(File.separator);
                if (digitalNet.b != n) {
                    stringBuffer.append("----------------------------------------------------------------------\n");
                    n = digitalNet.b;
                }
                String string2 = ((DigitalNetFromFile)digitalNet).filename.substring(n2 + 1);
                stringBuffer.append(PrintfFormat.s(-25, string2) + PrintfFormat.d(10, digitalNet.b) + PrintfFormat.d(10, digitalNet.dim) + PrintfFormat.d(10, digitalNet.numRows) + PrintfFormat.d(10, digitalNet.numCols) + "\n");
            }
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("formatPlain: cannot find directory   " + string);
            throw nullPointerException;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void listDirHTML(String string, String string2) throws IOException {
        String string3 = DigitalNetFromFile.listDir(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string3));
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(95);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.slashSlashComments(false);
        streamTokenizer.slashStarComments(false);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
        printWriter.println("<html>\n<head>\n<title>");
        while (streamTokenizer.nextToken() != 10) {
        }
        printWriter.println("\n</title>\n</head>");
        printWriter.println("<body>");
        printWriter.println("<table border>");
        printWriter.println("<caption> Directory: " + string + "</caption>");
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        while (streamTokenizer.sval.compareTo("File") != 0) {
            streamTokenizer.nextToken();
        }
        printWriter.print("<tr align=center><th>" + streamTokenizer.sval + "</th>");
        while (streamTokenizer.nextToken() != 10) {
            printWriter.print("<th>" + streamTokenizer.sval + "</th>");
        }
        printWriter.println("</tr>\n");
        block8: while (true) {
            if (streamTokenizer.nextToken() == -1) {
                printWriter.println("</table>");
                printWriter.println("</body>\n</html>");
                printWriter.close();
                return;
            }
            switch (streamTokenizer.ttype) {
                case 10: {
                    printWriter.println("</tr>");
                    continue block8;
                }
                case -2: {
                    printWriter.print("<td>" + (int)streamTokenizer.nval + "</td>");
                    continue block8;
                }
                case -3: {
                    if (streamTokenizer.sval.indexOf("---") >= 0) {
                        streamTokenizer.nextToken();
                        continue block8;
                    }
                    printWriter.print("<tr align=center><td>" + streamTokenizer.sval + "</td>");
                    continue block8;
                }
            }
            printWriter.print(streamTokenizer.sval);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class NetComparator
    implements Comparator {
        NetComparator() {
        }

        public int compare(Object object, Object object2) {
            DigitalNetFromFile digitalNetFromFile = (DigitalNetFromFile)object;
            DigitalNetFromFile digitalNetFromFile2 = (DigitalNetFromFile)object2;
            if (digitalNetFromFile.b < digitalNetFromFile2.b) {
                return -1;
            }
            if (digitalNetFromFile.b > digitalNetFromFile2.b) {
                return 1;
            }
            if (digitalNetFromFile.filename.indexOf("_") >= 0 && digitalNetFromFile2.filename.indexOf("_") < 0) {
                return 1;
            }
            if (digitalNetFromFile2.filename.indexOf("_") >= 0 && digitalNetFromFile.filename.indexOf("_") < 0) {
                return -1;
            }
            if (digitalNetFromFile.dim < digitalNetFromFile2.dim) {
                return -1;
            }
            if (digitalNetFromFile.dim > digitalNetFromFile2.dim) {
                return 1;
            }
            if (digitalNetFromFile.numRows < digitalNetFromFile2.numRows) {
                return -1;
            }
            if (digitalNetFromFile.numRows > digitalNetFromFile2.numRows) {
                return 1;
            }
            return 0;
        }
    }
}

