/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import cern.colt.list.AbstractList;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;

public abstract class CycleBasedPointSet
extends PointSet {
    protected int numCycles = 0;
    private double[] shift;
    protected ObjectArrayList cycles = new ObjectArrayList();

    public double getCoordinate(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 <= n) {
            n3 = ((AbstractList)this.cycles.get(n5)).size();
            n4 += n3;
            ++n5;
        }
        AbstractList abstractList = (AbstractList)this.cycles.get(n5 - 1);
        int n6 = (n - n4 + n3 + n2) % abstractList.size();
        double d = ((DoubleArrayList)abstractList).get(n6);
        return d;
    }

    public void addRandomShift(int n, int n2, RandomStream randomStream) {
        int n3;
        if (null == randomStream) {
            throw new IllegalArgumentException("\n   Calling addRandomShift with null stream");
        }
        if (0 == n2) {
            n2 = Math.max(this.dim, 1);
        }
        if (this.shift == null) {
            this.shift = new double[n2];
            this.capacityShift = n2;
        } else if (n2 > this.capacityShift) {
            for (n3 = Math.max(4, this.capacityShift); n2 > n3; n3 *= 2) {
            }
            double[] dArray = new double[n3];
            this.capacityShift = n3;
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.shift[i];
            }
            this.shift = dArray;
        }
        this.dimShift = n2;
        for (n3 = n; n3 < n2; ++n3) {
            this.shift[n3] = randomStream.nextDouble();
        }
        this.shiftStream = randomStream;
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.shift = null;
    }

    protected void addCycle(AbstractList abstractList) {
        this.cycles.add(abstractList);
        ++this.numCycles;
        this.numPoints += abstractList.size();
    }

    public int getDimension() {
        return Integer.MAX_VALUE;
    }

    public PointSetIterator iterator() {
        return new CycleBasedPointSetIterator();
    }

    public String toString() {
        String string = super.toString();
        return string + "\nNumber of cycles: " + this.numCycles;
    }

    public String formatPoints() {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        for (int i = 0; i < this.numCycles; ++i) {
            AbstractList abstractList = (AbstractList)this.cycles.get(i);
            double[] dArray = ((DoubleArrayList)abstractList).elements();
            stringBuffer.append("\nCycle " + i + ": (");
            boolean bl = true;
            for (int j = 0; j < abstractList.size(); ++j) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(dArray[j]);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public class CycleBasedPointSetIterator
    extends PointSet.DefaultPointSetIterator {
        protected int startPointInCycle = 0;
        protected int curCoordInCycle = 0;
        protected int curCycleIndex = 0;
        protected AbstractList curCycle;
        protected double[] curCycleD;

        public CycleBasedPointSetIterator() {
            super(CycleBasedPointSet.this);
            this.init();
        }

        protected void init() {
            this.resetCurCycle(0);
        }

        public void resetCurCycle(int n) {
            this.curCycleIndex = n;
            this.curCycle = (AbstractList)CycleBasedPointSet.this.cycles.get(n);
            this.curCycleD = ((DoubleArrayList)this.curCycle).elements();
        }

        public void setCurCoordIndex(int n) {
            this.curCoordIndex = n;
            this.curCoordInCycle = (n + this.startPointInCycle) % this.curCycle.size();
        }

        public void resetCurCoordIndex() {
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
        }

        public boolean hasNextCoordinate() {
            return true;
        }

        public double nextDouble() {
            return this.nextCoordinate() + this.EpsilonHalf;
        }

        public double nextCoordinate() {
            if (this.getCurPointIndex() >= CycleBasedPointSet.this.getNumPoints()) {
                this.outOfBounds();
            }
            double d = this.curCycleD[this.curCoordInCycle];
            if (CycleBasedPointSet.this.shift != null) {
                if (this.curCoordIndex >= CycleBasedPointSet.this.dimShift) {
                    CycleBasedPointSet.this.addRandomShift(CycleBasedPointSet.this.dimShift, this.curCoordIndex + 1, CycleBasedPointSet.this.shiftStream);
                }
                if ((d += CycleBasedPointSet.this.shift[this.curCoordIndex]) >= 1.0) {
                    d -= 1.0;
                }
            }
            ++this.curCoordIndex;
            ++this.curCoordInCycle;
            if (this.curCoordInCycle >= this.curCycle.size()) {
                this.curCoordInCycle = 0;
            }
            return d;
        }

        public void nextCoordinates(double[] dArray, int n) {
            if (this.getCurPointIndex() >= CycleBasedPointSet.this.getNumPoints()) {
                this.outOfBounds();
            }
            if (this.curCoordIndex + n >= CycleBasedPointSet.this.dimShift) {
                CycleBasedPointSet.this.addRandomShift(CycleBasedPointSet.this.dimShift, this.curCoordIndex + n + 1, CycleBasedPointSet.this.shiftStream);
            }
            int n2 = this.curCoordInCycle;
            int n3 = this.curCycle.size();
            for (int i = 0; i < n; ++i) {
                double d = this.curCycleD[this.curCoordInCycle++];
                if (this.curCoordInCycle >= n3) {
                    this.curCoordInCycle = 0;
                }
                if (CycleBasedPointSet.this.shift != null && (d += CycleBasedPointSet.this.shift[this.curCoordIndex + i]) >= 1.0) {
                    d -= 1.0;
                }
                dArray[i] = d;
            }
            this.curCoordIndex += n;
        }

        public void setCurPointIndex(int n) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n3 <= n) {
                n2 = ((AbstractList)CycleBasedPointSet.this.cycles.get(n4)).size();
                n3 += n2;
                ++n4;
            }
            this.resetCurCycle(n4 - 1);
            this.startPointInCycle = n - n3 + n2;
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
        }

        public void resetCurPointIndex() {
            this.resetCurCycle(0);
            this.startPointInCycle = 0;
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
            this.curCoordInCycle = 0;
        }

        public int resetToNextPoint() {
            ++this.curPointIndex;
            ++this.startPointInCycle;
            if (this.startPointInCycle >= this.curCycle.size()) {
                this.startPointInCycle = 0;
                if (this.curCycleIndex < CycleBasedPointSet.this.numCycles - 1) {
                    this.resetCurCycle(this.curCycleIndex + 1);
                }
            }
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
            return this.curPointIndex;
        }

        public int nextPoint(double[] dArray, int n) {
            if (this.getCurPointIndex() >= CycleBasedPointSet.this.getNumPoints()) {
                this.outOfBounds();
            }
            int n2 = this.startPointInCycle;
            int n3 = this.curCycle.size() - 1;
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.curCycleD[n2];
                if (n2 < n3) {
                    ++n2;
                    continue;
                }
                n2 = 0;
            }
            this.resetToNextPoint();
            return this.curPointIndex;
        }

        public String formatState() {
            return super.formatState() + "\nCurrent cycle: " + this.curCycleIndex;
        }
    }
}

