/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Reporter;
import uibk.mtk.swing.base.TextField;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.swing.datatable.DataTable;

public class PanelCreateDataGrid
extends TitledPanel
implements ActionListener {
    private static final String BUNDLE_NAME = "uibk.mtk.swing.datatable.messages";
    private final int maxCols;
    private final int maxRows;
    private final DataTable table;
    private final Reporter reporter;
    private final Component parentComponent;
    private TextField textnumbercols;
    private TextField textnumberrows;
    private int rows;
    private int cols;
    private int minVar = 2;
    private boolean gls = true;

    public PanelCreateDataGrid(int maxRows, int maxCols, DataTable table, Reporter reporter, Component parentComponent) {
        super(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.0"));
        this.maxCols = maxCols;
        this.maxRows = maxRows;
        this.table = table;
        this.reporter = reporter;
        this.parentComponent = parentComponent;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.textnumbercols = new TextField(10);
        this.textnumbercols.setActionCommand("creategrid");
        this.textnumbercols.addActionListener(this);
        this.textnumbercols.setToolTipText(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.2"));
        this.textnumberrows = new TextField(10);
        this.textnumberrows.setActionCommand("creategrid");
        this.textnumberrows.addActionListener(this);
        this.textnumberrows.setToolTipText(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.4"));
        JButton buttoncreate = new JButton(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.5"));
        buttoncreate.setActionCommand("creategrid");
        buttoncreate.addActionListener(this);
        buttoncreate.setToolTipText(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.7"));
        this.setMaximumSize(new Dimension(2000, 120));
        this.add((Component)new JLabel(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.8")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.textnumbercols, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.9")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.textnumberrows, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)buttoncreate, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
    }

    private boolean getRows() {
        try {
            this.rows = Integer.parseInt(this.textnumberrows.getText());
        }
        catch (NumberFormatException e) {
            this.reporter.reportError(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.10"), this.parentComponent);
            return false;
        }
        if (this.rows < this.minVar) {
            this.reporter.reportError(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.11"), this.parentComponent);
            return false;
        }
        if (this.rows > this.maxRows) {
            this.reporter.reportError(String.valueOf(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.12")) + this.maxRows + Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.13"), this.parentComponent);
            return false;
        }
        return true;
    }

    private boolean getCols() {
        try {
            this.cols = Integer.parseInt(this.textnumbercols.getText());
        }
        catch (NumberFormatException e) {
            this.reporter.reportError(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.14"), this.parentComponent);
            return false;
        }
        if (this.cols < this.minVar) {
            this.reporter.reportError(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.15"), this.parentComponent);
            return false;
        }
        if (this.cols > this.maxCols) {
            this.reporter.reportError(String.valueOf(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.16")) + this.maxCols + Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.17"), this.parentComponent);
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("creategrid")) {
            if (!this.getRows() || !this.getCols()) {
                return;
            }
            if (this.gls && this.rows < this.cols) {
                this.reporter.reportError(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.19"));
                return;
            }
            this.table.create(this.rows, this.cols);
            this.table.getColumn(this.table.getColumnName(0)).setMaxWidth(40);
            this.reporter.reportSuccess(String.valueOf(this.rows) + "x" + this.cols + Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.21"));
        }
    }

    public void setMinVar(int minVar) {
        this.minVar = minVar;
    }

    public void setGls(boolean gls) {
        this.gls = gls;
    }
}

