/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import java.util.Vector;
import uibk.mtk.swing.datatable.Messages;

class Datagrid {
    private int m = 0;
    private int n = 0;
    private Vector data = new Vector();

    public Datagrid() {
        this(0, 0);
    }

    public void clear() {
        this.data.clear();
        this.m = 0;
        this.n = 0;
    }

    private void create(int rows, int cols) {
        this.data.ensureCapacity(rows);
        this.data = new Vector(rows);
        int i = 0;
        while (i < rows) {
            this.data.add(new Object[cols]);
            ++i;
        }
        this.m = rows;
        this.n = cols;
    }

    public Datagrid(int m, int n) {
        this.create(m, n);
    }

    public Object getValue(int i, int j) {
        if (i > this.m - 1 || j > this.n - 1) {
            throw new IllegalArgumentException("");
        }
        return ((Object[])this.data.elementAt(i))[j];
    }

    public void setValue(Object value, int i, int j) {
        if (i > this.m - 1 || j > this.n - 1) {
            throw new IllegalArgumentException("");
        }
        ((Object[])this.data.elementAt((int)i))[j] = value;
    }

    public void addrow(Object[] obj) {
        if (this.n != 0 && obj.length != this.n) {
            throw new IllegalArgumentException(Messages.getString("Datagrid.2"));
        }
        if (this.n == 0) {
            this.n = obj.length;
        }
        this.data.add(obj);
        ++this.m;
    }

    public int getRows() {
        return this.m;
    }

    public int getColumns() {
        return this.n;
    }

    boolean isComplete() {
        int i = 0;
        while (i < this.m) {
            int j = 1;
            while (j < this.n) {
                if (((Object[])this.data.elementAt(i))[j] == null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    boolean isEmpty() {
        return this.data == null || this.m == 0 || this.n == 0;
    }
}

