/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import uibk.mtk.swing.datatable.MyTableModel;

public class DataTable
extends JTable {
    MyTableModel tm;

    public void scrollToLastLine() {
        if (this.getRowCount() >= 1) {
            this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            Rectangle rect = this.getCellRect(this.getRowCount(), 0, true);
            this.scrollRectToVisible(rect);
        }
    }

    public void cleardata() {
        this.tm.cleardata();
    }

    public DataTable(double[][] data) {
        super(new MyTableModel(data));
        this.tm = (MyTableModel)this.dataModel;
    }

    public DataTable(int rows, int cols) {
        super(new MyTableModel(rows, cols));
        this.tm = (MyTableModel)this.dataModel;
    }

    public DataTable() {
        this((double[][])null);
    }

    public DataTable(String[] labels) {
        this(0, labels.length);
        this.tm.columnnames = labels;
        this.tm.fireTableStructureChanged();
    }

    public DataTable(double[][] data, String[] labels) {
        this(data);
        this.tm.columnnames = labels;
        this.tm.fireTableStructureChanged();
    }

    public void setData(double[][] data) {
        ((MyTableModel)this.dataModel).setData(data);
    }

    public void setData(double[][] data, String[] labels) {
        if (labels.length != data.length) {
            throw new IllegalArgumentException("");
        }
        this.tm.columnnames = labels;
        ((MyTableModel)this.dataModel).setData(data);
    }

    public void add(double[] data) {
        Object[] dd = new Double[data.length];
        int i = 0;
        while (i < data.length) {
            dd[i] = new Double(data[i]);
            ++i;
        }
        this.tm.datagrid.addrow(dd);
    }

    public void create(int rows, int cols) {
        String[] newlables = new String[cols];
        int i = 0;
        while (i < cols) {
            newlables[i] = "x" + (i + 1);
            ++i;
        }
        this.tm.columnnames = newlables;
        ((MyTableModel)this.dataModel).create(rows, cols);
    }

    public double[][] getData() {
        int m = this.tm.getRowCount();
        int n = this.tm.getColumnCount();
        double[][] data = new double[n][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                data[j][i] = (Double)this.tm.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public double[][] getDataCols(int[] cols) {
        int m = this.tm.getRowCount();
        int n = cols.length;
        double[][] data = new double[n][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                data[j][i] = (Double)this.tm.getValueAt(i, cols[j]);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public double[] getDataCol(int col) {
        int m = this.tm.getRowCount();
        double[] data = new double[m];
        int i = 0;
        while (i < m) {
            data[i] = (Double)this.tm.getValueAt(i, col);
            ++i;
        }
        return data;
    }

    public boolean isEmpty() {
        return this.tm.datagrid.isEmpty();
    }

    public boolean isComplete() {
        return this.tm.datagrid.isComplete();
    }

    public void setColumnWidthFromLabels() {
        this.setAutoResizeMode(0);
        Graphics g = this.getGraphics();
        if (g == null || this.tm.columnnames == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        this.getColumn(this.getColumnName(0)).setPreferredWidth(metrics.stringWidth(this.tm.countername) + 20);
        int i = 0;
        while (i < this.getColumnCount() - 1) {
            String str = this.tm.columnnames[i];
            this.getColumn(this.getColumnName(i + 1)).setPreferredWidth(metrics.stringWidth(str) + 20);
            ++i;
        }
    }
}

