/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.bisection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uibk.applets.bisection.AppletBisection;
import uibk.applets.bisection.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction1D;
import uibk.mtk.math.parsing.Function1DParser;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.TitledPanel;

public class PanelDefFunction
extends TitledPanel
implements ActionListener {
    AppletBisection main;
    JTextField textFunction;
    IntervalTextField textIntervall;

    public PanelDefFunction(AppletBisection main) {
        super(Messages.getString("PanelDefFunction.DefineFunctionAndDraw"));
        this.main = main;
        this.initComponents();
    }

    private void draw() {
        Interval interval;
        ParsedFunction1D function;
        try {
            function = Function1DParser.parse("x", this.textFunction.getText());
            interval = this.textIntervall.getInterval();
        }
        catch (Exception ex) {
            this.main.bisecvisual.setVisible(false);
            this.main.mathpanel2d.getScene2d().setLimits(-1.0, 1.0, -1.0, 1.0);
            this.main.mathpanel2d.repaint();
            this.main.panelbisection.setEnabled(false);
            this.main.mathpanel2d.reportError(ex);
            return;
        }
        this.main.bisecvisual.reset();
        this.main.bisecvisual.setStartInterval(interval);
        this.main.bisecvisual.setFunction(function);
        try {
            this.main.bisecvisual.initialize();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            this.main.bisecvisual.setVisible(false);
            this.main.mathpanel2d.getScene2d().setLimits(-1.0, 1.0, -1.0, 1.0);
            this.main.panelbisection.setEnabled(false);
            this.main.mathpanel2d.repaint();
            return;
        }
        this.main.bisecvisual.setVisible(true);
        this.main.table.cleardata();
        this.main.table.revalidate();
        this.main.panelbisection.setEnabled(true);
        this.main.mathpanel2d.repaint();
        this.main.mathpanel2d.report(Messages.getString("PanelDefFunction.FunctionDrawn"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("draw")) {
            this.draw();
        }
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 140));
        this.textFunction = new JTextField(12);
        this.textFunction.setActionCommand("draw");
        this.textFunction.addActionListener(this);
        this.textFunction.setToolTipText(Messages.getString("PanelDefFunction.EnterFunctionHere"));
        this.textIntervall = new IntervalTextField(6, Messages.getString("PanelDefFunction.Interval"), true);
        this.textIntervall.setActionCommand("draw");
        this.textIntervall.addActionListener(this);
        this.textIntervall.setToolTipText(Messages.getString("PanelDefFunction.EnterIntervallForParamterHere"));
        JButton buttonDraw = new JButton(Messages.getString("PanelDefFunction.Draw"));
        buttonDraw.setActionCommand("draw");
        buttonDraw.addActionListener(this);
        buttonDraw.setToolTipText(Messages.getString("PanelDefFunction.DrawtheFunction"));
        JLabel labelFunction = new JLabel("f(x)=");
        JLabel labelIntervall = new JLabel(Messages.getString("PanelDefFunction.Interval"));
        this.add((Component)labelFunction, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.textFunction, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)labelIntervall, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.textIntervall, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)buttonDraw, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
    }
}

