%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function printmds(MDS,file,options)

%
% printmds(MDS,file,options)
%
% prints an EPANET2 input file
%
% file     file name of the EPANET2 input file
% options  a file appended to the input file with additional 
%          information as [OPTIONS ], [REPORT],...

fout = fopen(file,'wt');

if (~fout)
  error(['Can''t write input file ',file])
end

fprintf(fout,';MDS ouptput   %s\n\n\n',datestr(now));
printjunctions(MDS,fout);
printreservoirs(MDS,fout);
printpipes(MDS,fout);

S = textread(options,'%s','delimiter','\n','whitespace','');

fprintf(fout,';options:\n\n\n');
for i=1:length(S)
  fprintf(fout,'%s\n',S{i});
end

fclose(fout);


function printjunctions(MDS,fout,J)

mdstypes

if (nargin==1)
  fout = 1;
end

if (nargin<=2)
  J = junctions(MDS);
end

fprintf(fout,'[JUNCTIONS]\n;  ID     Elev   Demand ; Set Type     x       y        z\n');
fprintf(fout,';-----------------------------------------------------------\n');
fprintf(fout,'%5d %8.2f %8.2f ; %3d %3d %8.2f %8.2f %8.2f\n',J'); 
  
fprintf(fout,'\n\n\n');


function printreservoirs(MDS,fout,R)

if (nargin==1)
  fout = 1;
end

if (nargin<=2);
  R = reservoirs(MDS);
end

fprintf(fout,'[RESERVOIRS]\n;;  ID     Elev ; Set Type    x        y        z\n');
fprintf(fout,';--------------------------------------------------\n');
fprintf(fout,'%5d %8.2f ; %3d %3d %8.2f %8.2f %8.2f\n',R'); 

fprintf(fout,'\n\n\n');


function printpipes(MDS,fout,P)

mdstypes

if (nargin==1)
  fout = 1;
end

if (nargin<=2)
  P = pipes(MDS);
end

fprintf(fout,'[PIPES]\n;  ID Node1 Node2   Length     Diam Roughness; Set Type\n');
fprintf(fout,';------------------------------------------------------\n');
fprintf(fout,'%5d %5d %5d %8.2f %8.2f %8.2f ; %3d %3d\n',P');

fprintf(fout,'\n\n\n');


