%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plotmds(MDS,nres,ares)

%
% plotmds(MDS)
% plotmds(MDS,nres)
% plotmds(MDS,nres,ares)
% plotmds(MDS,[],ares)
%
% plots MDS
%
% nres   plots results nres for nodes
% ares   plots results ares for arcs

mdstypes
mdsdefault
colors
layout


A = arcs(MDS);
ND = nodes(MDS,1);



jetcol = jet(64);

if (nargin>2)
  if (max(ares)-min(ares)==0)
    d = 1;
  else
    d = max(ares)-min(ares);
  end
  for i=1:size(A,1)
    t = A(i,7);
    if (bitand2(t,PIPES))
      coli = ...
	  ceil(62*(nres(i)-min(nres(I)))/(max(nres(I))-min(nres(I))))+1;
      col = jetcol(coli,:);
    else
      col = [1 1 1];
    end
    lw = acol(t,4);
    line(ND(A(i,2:3),end-2),ND(A(i,2:3),end-1),...
	'color',col,...
	'linewidth',lw)
  end
else
  for i=1:size(A,1)
    t = A(i,7);
    col = acol(t,1:3);
    lw = acol(t,4);
    line(ND(A(i,2:3),end-2),ND(A(i,2:3),end-1),...
	'color',col,...
	'linewidth',lw)
  end
end

I = find(bitand2(ND(:,4),JUNCTIONS));
if (nargin>1 && ~isempty(nres))
  for i=1:size(ND,1)
    t = ND(i,4);
    if (bitand2(t,JUNCTIONS))
      coli = ...
	  ceil(62*(nres(i)-min(nres(I)))/(max(nres(I))-min(nres(I))))+1;
      col = jetcol(coli,:);
    else
      col = [1 1 1];
    end
    lw = ncol(t,4);  
    line(ND(i,end-2),ND(i,end-1),...
	'linestyle','none',...
	'marker',marker(ncol(t,5)),...
	'markerfacecolor','w',...
	'markersize',lw,...
	'color',col)
%    text(ND(i,end-2)+.1,ND(i,end-1)+.2,num2str(nres(i),'%4.1f'),'fontsize',6)
  end
else
  for i=1:size(ND,1)
    t = ND(i,4);
    col = ncol(t,1:3);
    lw = ncol(t,4);  
    line(ND(i,end-2),ND(i,end-1),...
	'linestyle','none',...
	'marker',marker(ncol(t,5)),...
	'markerfacecolor',[.7,.7,.7],...
	'markersize',lw,...
	'color',col)
%    text(ND(i,end-2)+.1,ND(i,end-1)+.2,num2str(i),'fontsize',6)
  end
end

axis equal
axis off

ax = axis;
ax = ax+[-.1 .1 -.1 .1];
axis(ax)


