%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [P,HP,VP]=pipes(MDS)

mdstypes

[m,n] = size(MDS);

MDS = pipelength(MDS);

[A,HA,VA] = arcs(MDS);

I = find(bitand2(HA(:,7),PIPES));
index = HA(I,1);
HP = [HA(I,2:3),MDS.hpipes.length(index), ...
  MDS.hpipes.diam(index), ...
  MDS.hpipes.roughness(index),...
  HA(I,6:end)];

I = find(bitand2(VA(:,7),PIPES));
index = VA(I,1);
VP = [VA(I,2:3),MDS.vpipes.length(index), ...
  MDS.vpipes.diam(index), ...
  MDS.vpipes.roughness(index),...
  VA(I,6:end)];

P = [HP;VP];
P = [(1:size(P,1))' P];