%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function MDS=pipelength(MDS)

mdsdefault

MDS = defaultcoord(MDS);

[m,n] = size(MDS);

index = find(bitand(MDS.graph,1));
I = [index index+m]';
MDS.hpipes.length(index) = ...
    sqrt(diff(MDS.nodes.x(I)).^2+ ...
    +diff(MDS.nodes.y(I)).^2+ ...
    +diff(MDS.nodes.z(I)).^2)';

index = find(bitand(MDS.graph,2));
I = [index index-1]';

MDS.vpipes.length(index) = ...
    sqrt(diff(MDS.nodes.x(I)).^2+ ...
    +diff(MDS.nodes.y(I)).^2+ ...
    +diff(MDS.nodes.z(I)).^2)';
