%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function ND=nodes(MDS,flag)

%
% ND = nodes(MDS)
%
% returns the nodes of MDS
%
% ND  nnodes x 7 matrix with columns
%
% id, index, set, type, x, y, z


mdstypes

[m,n] = size(MDS);
index = find(MDS.graph);
I = index;

T = MDS.nodes.type(I);

if (nargin==2)
  J = find((T==JUNCTIONS) & MDS.junctions.demand(I)==0);
  T(J) = DUMMYNODE;
end

ND = [ MDS.nodes.set(I), T,...
      MDS.nodes.x(I),MDS.nodes.y(I),MDS.nodes.z(I)];

ND = [(1:size(ND,1))' I ND];

