%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function MDS=connect(MDS)

mdstypes

[m,n] = size(MDS);

index = find(MDS.graph & MDS.nodes.type==AUTOCONNECT)';

for i=index
  switch (MDS.graph(i))
    case LEFT,
      k = i;
      MDS.graph(k) = LEFT_RIGHT;
      while (k+m<=m*n)
	if (MDS.graph(k+m))
	  MDS.graph(k+m) = bitor(MDS.graph(k+m),LEFT);
	  MDS.harc.type(k) = DUMMYARC;
	  MDS.hpipes(k) = MDS.hpipes(k-m);
	  break
	else
	  MDS.graph(k+m) = LEFT_RIGHT;
	end
	MDS.harc.type(k) = DUMMYARC;
	MDS.hpipes(k) = MDS.hpipes(k-m);
	MDS.nodes.type(k+m) = DUMMYNODE;
	MDS.junctions(k+m) = MDS.junctions(k);
	k = k+m;
      end
    case RIGHT, % this means "search on the left side"
      k = i;
      MDS.graph(k) = LEFT_RIGHT;  
      while (k-m>=1)
	if (MDS.graph(k-m))
	  MDS.graph(k-m) = bitor(MDS.graph(k-m),RIGHT);
	  MDS.harc.type(k-m) = DUMMYARC;
	  MDS.hpipes(k-m) = MDS.hpipes(k);
	  break
	else
	  MDS.graph(k-m) = LEFT_RIGHT;
	end
	MDS.harc.type(k-m) = DUMMYARC;
	MDS.hpipes(k-m) = MDS.hpipes(k);
	MDS.nodes.type(k-m) = DUMMYNODE;
	MDS.junctions(k-m) = MDS.junctions(k);
	k = k-m;
      end
    case DOWN,
      k = i;
      MDS.graph(k) = UP_DOWN;
      MDS.vpipes(k) = MDS.vpipes(k+1);
      while (k-1>=1)
	if (MDS.graph(k-1))
	  MDS.graph(k-1) = bitor(MDS.graph(k-1),DOWN);
	  MDS.varc.type(k) = DUMMYARC;
	  MDS.vpipes(k) = MDS.vpipes(k+1);
	  break
	else
	  MDS.graph(k-1) = UP_DOWN;
	end
	MDS.varc.type(k) = DUMMYARC;
	MDS.vpipes(k) = MDS.vpipes(k+1);
	MDS.nodes.type(k-1) = DUMMYNODE;
	MDS.junctions(k-1) = MDS.junctions(k);
	k = k-1;
      end
    case UP,
      k = i;
      MDS.graph(k) = UP_DOWN;
      while (k+1<=m*n)
	if (MDS.graph(k+1))
	  MDS.graph(k+1) = bitor(MDS.graph(k+1),UP);
	  MDS.varc.type(k+1) = DUMMYARC;
	  MDS.vpipes(k+1) = MDS.vpipes(k);
	  break
	else
	  MDS.graph(k+1) = UP_DOWN;
	end
	MDS.varc.type(k+1) = DUMMYARC;
	MDS.vpipes(k+1) = MDS.vpipes(k);
	MDS.nodes.type(k+1) = DUMMYNODE;
	MDS.junctions(k+1) = MDS.junctions(k);
	k = k+1;
      end
  end
end
