%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [A,HA,VA]=arcs(MDS)

%
% [A,HA,VA] = arcs(MDS)
%
% returns arcs of MDS
%
% A   all arcs
% HA  horizontal arcs only
% VA  vertical arcs only
%
% A, HA, VA  are narcs x 7 matrices with columns
%
% id, start node, end node, start index, end index, set, type



[m,n] = size(MDS);

graph = MDS.graph;

index = find(graph);
nd = zeros(m,n);
nd(index) = 1:length(index);

index = find(bitand(graph,1));
I = [index index+m]';

HA =[index,nd(I'),I',MDS.harc.set(index),MDS.harc.type(index)];


index = find(bitand(graph,2));
I = [index index-1]';

VA = [index,nd(I'),I',MDS.varc.set(index),MDS.varc.type(index)];

A = [HA;VA];
