%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%  example2.m
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% in this m-file the keywords are defined (RESERVOIRS, JUNCTIONS,...)
mdstypes

% the modules
% -----------

%     J . J
%     |   |
% E:  J-J-J
%     |   |
%     J . J

E = [8 0 8
     11 5 14
     2  0 2];
E = mds(E);

%      . J                         J .
%        |           J-J-J         |          . J .
% B1:  J-J     B2:     |     B3:   J-J   B4:    |
%        |           . J .         |          J-J-J
%      . J                         J .


B1 = [0 8
      1 14
      0 2];
B1 = mds(B1);
B2 = rotate(B1,1);   % rotating,  90 counterclockwise
B3 = rotate(B1,2);   % rotating, 180 counterclockwise
B4 = rotate(B1,3);   % rotating, 270 counterclockwise

%       . . .          . J .
%                        |
%  I1:  J-J-J     I2:  . J .
%                        |
%       . . .          . J .


I1 = [0  0 0
      1  5 4
      0  0 0];
I1 = mds(I1);
I2 = rotate(I1,1);


%       . J         J-J        J-J          J .
% C1:     |   C2:     |   C3:  |       C4:  |
%       J-J         . J        J .          J-J

C1 = [0 8
      1 6];
C1 = mds(C1);
C2 = rotate(C1,1);
C3 = rotate(C1,2);
C4 = rotate(C1,3);

IC1 = B4;
IC2 = B1;
IC3 = B2;
IC4 = B3;


% concatenating
% -------------

% left boundary
N0 = [C3
     B3
     C4];
   
% inner part   
N1 = [B2,IC3;
      E, I1,;
      B4,IC1];

% right boundary
N2 = [B2,C2;
      E,B1;
      B4,C1];

% concatenating the WDS (without reservoirs)    
% N = [N0 N1 N1 N1 N1 N2]     
N = N0;
for i=1:4
  N = [N,N1];
end
N = [N,N2];


% setting the properties
N.junctions.demand = 1;
N.junctions.elev = 0;

N.pipes.roughness = 0.4;
N.pipes.diam = 200;


% reservoir
% ---------
% 
%  R
%  |
%  A

R = [8
     2];
R = mds(R);

% setting the types
R.nodes.type = [RESERVOIRS; 
                AUTOCONNECT];
R.arc.type  = PIPES;

% setting the properties
R.reservoirs.head = 100;
R.junctions.demand = 0;  % the autoconnecting node is always a junction!
R.junctions.elev = 0;

R.pipes.roughness = 0.4;
R.pipes.diam = 200;


% building up the WDS
% -------------------

% initializing an empty module
[m,n]=size(N);
M = mds(2*m,n);

% inserting the WDS N at (6,1)
M(6,1) = N;

% inserting the reservoirs R at (1,5), (1,11) and (1,17) 
M(1,[5 11 17]) = R;

% apply the auto-connecting feature
M = connect(M);


% geometric properties
% --------------------

% assigning x- and y-coordinates to the nodes
X = 100*(0:1:size(M,2)-1);
Y = 100*(size(M,1)-1:-1:0);
[X,Y] = meshgrid(X,Y);


M.nodes.x = X;
M.nodes.y = Y;

% plot the module
plotmds(M)

% writing an input file 'example1.inp' for epanet
% 'options.inp' is a file with additional options appended to example1.inp
printmds(M,'example2.inp','options.inp')










