%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS Modular Design System  1.00 2007         
%  Th. Fetz, M. Mderl    
%  http://techmath.uibk.ac.at/fetz/downloads/mds.zip
%
%  example1.m
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% in this m-file the keywords are defined (RESERVOIRS, JUNCTIONS,...)
mdstypes

% water distribution system D
% ---------------------------
%
% [1] graph matrix for module D
%
%   J-J-J-J-J
%   |   |   |
%   J J-J-J J
%   | | | | |
%   J-J-J-J-J
%   | | | | |
%   J J-J-J J
%   |   |   |
%   J-J-J-J-J

GD = [9     5    13     5    12
     10     9    15    12    10
     11    15    15    15    14
     10     3    15     6    10
      3     5     7     5     6];

% [2] generating the module D by means of the graph matrix GD  
D = mds(GD);

% [3] setting the types of the nodes, by default all nodes are junctions

% [4] setting properties

% setting of the pipe properties affecting ALL pipes of the module
D.pipes.roughness = 0.4;
D.pipes.diam = 80;

% setting of the junction properties affecting ALL junctions of the module
D.junctions.demand = 1;    
D.junctions.elev = 0;    


% reservoir and connections type R0
% ---------------------------------
%
% [1] graph matrix for module R0
%
%    R
%    |
%    J
%    |
%    J
 
GR0 = [8
      10 
       2];

     
% [2] generating the module R0 by means of the graph matrix GR0    
R0 = mds(GR0);    

% [3] setting the types of the nodes
% now we have not only junctions, the node at the top is a reservoir and
% the other nodes are junctions
R0.nodes.type = [RESERVOIRS;
                 JUNCTIONS;
		 JUNCTIONS];

% [4] setting the properties

% setting of the pipe properties affecting ALL pipes of the module
R0.pipes.roughness = 0.4;
R0.pipes.diam = 200;

% setting of the junction properties affecting ALL JUNCTIONS of the module
R0.junctions.demand = 0;
R0.junctions.elev = 0;    

% setting of the reseveroir property affecting ALL RESERVOIRS of the module
R0.reservoirs.head = 100;



% reservoir and connections type R1
% ---------------------------------
%
% [1] graph matrix for module R1
%
%    R
%    |
%    J-A
%    |
%    J

GR1 = [8 0
      11 4 
       2 0];
    
% [2] generating the module R1
R1 = mds(GR1);    

% [3] setting the types of the nodes
R1.nodes.type = [RESERVOIRS    NONE;
                 JUNCTIONS AUTOCONNECT;
		 JUNCTIONS     NONE];

% [4] setting the properties	
	       
% setting the pipe properties affecting ALL PIPES
R1.pipes.roughness = 0.4;
R1.pipes.diam = 200;

% setting the junction properties affecting ALL JUNCTIONS
R1.junctions.demand = 0;    
R1.junctions.elev = 0;    

% setting the reservoir property
R1.reservoirs.head = 100;

% building up the WDS using the above modules
% -------------------------------------------

% number of complexes 
N = 2;

% initializing empty module
% -------------------------

M = mds(size(D,1)+2,N*(size(D,2)+1));

% inserting modules D, R1, R0, D
% ------------------------------

% inserting module D at nodes (3,1) and (3,7) of M 
% (coordinates of the upper left node of module D)
M(3,1:6:N*6) = D;

% inserting R1 at (1,3)
M(1,2+(1:6:(N-1)*6)) = R1;

% inserting R0 at (1,9)
M(1,3+((N-1)*6)) = R0;

% apply the auto-connecting feature
M = connect(M);

% geometric properties
% --------------------

% assigning x- and y-coordinates to the nodes
a = linspace(0,pi/3,size(M,2));
r = linspace(1000,3000,size(M,1));
[a,r] = meshgrid(a,r);
X = r.*cos(a);
Y = r.*sin(a);

M.nodes.x = X;
M.nodes.y = Y;

% plot the module
plotmds(M)

% writing an input file 'example1.inp' for epanet
% 'options.inp' is a file with additional options appended to example1.inp
printmds(M,'example1.inp','options.inp')

