/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.StyledString;
import java.awt.Font;
import java.awt.font.TextAttribute;
import processing.core.PApplet;

public abstract class GTextBase
extends GAbstractControl {
    protected StyledString stext = new StyledString("");
    protected Font localFont = G4P.globalFont;

    public GTextBase(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
        this.setFont(this.localFont);
    }

    public void setText(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.stext.setText(string, Integer.MAX_VALUE);
        this.bufferInvalid = true;
    }

    public boolean loadText(String string) {
        StyledString styledString = StyledString.load(this.winApp, string);
        if (styledString != null) {
            this.setStyledText(styledString);
            this.stext.endIdx = -1;
            this.stext.startIdx = -1;
            this.bufferInvalid = true;
            return true;
        }
        return false;
    }

    public boolean saveText(String string) {
        this.stext.endIdx = -1;
        this.stext.startIdx = -1;
        StyledString.save(this.winApp, this.stext, string);
        return true;
    }

    public void setFont(Font font) {
        if (font != null && font != this.localFont) {
            this.localFont = font;
            this.bufferInvalid = true;
        }
    }

    public void setStyledText(StyledString styledString) {
        if (styledString != null) {
            this.stext = styledString;
            this.stext.setWrapWidth((int)this.width - 4);
            this.bufferInvalid = true;
        }
    }

    @Override
    public void forceBufferUpdate() {
        if (this.stext != null) {
            this.stext.invalidateText();
        }
        this.bufferInvalid = true;
    }

    public void setTextPlain() {
        this.stext.clearAttributes();
        this.bufferInvalid = true;
    }

    public void setTextBold(int n, int n2) {
        this.addAttributeImpl(G4P.WEIGHT, G4P.WEIGHT_BOLD, n, n2);
    }

    public void setTextBold() {
        this.addAttributeImpl(G4P.WEIGHT, G4P.WEIGHT_BOLD);
    }

    public void setTextItalic(int n, int n2) {
        this.addAttributeImpl(G4P.POSTURE, G4P.POSTURE_OBLIQUE, n, n2);
    }

    public void setTextItalic() {
        this.addAttributeImpl(G4P.POSTURE, G4P.POSTURE_OBLIQUE);
    }

    public StyledString getStyledText() {
        return this.stext;
    }

    public String getText() {
        return this.stext.getPlainText();
    }

    protected void addAttributeImpl(TextAttribute textAttribute, Object object) {
        this.stext.addAttribute(textAttribute, object);
        this.bufferInvalid = true;
    }

    protected void addAttributeImpl(TextAttribute textAttribute, Object object, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.stext.length()) {
            n2 = this.stext.length();
        }
        this.stext.addAttribute(textAttribute, object, n, n2);
        this.bufferInvalid = true;
    }
}

