/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GEvent;
import g4p_controls.GTextBase;
import g4p_controls.HotSpot;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GPanel
extends GTextBase {
    protected static int COLLAPSED_BAR_SPOT = 1;
    protected static int EXPANDED_BAR_SPOT = 2;
    protected static int SURFACE_SPOT = 0;
    protected boolean tabOnly = false;
    protected int tabHeight;
    protected int tabWidth;
    protected float dockX;
    protected float dockY;
    protected float lowX;
    protected float highX;
    protected float lowY;
    protected float highY;
    protected boolean beingDragged = false;
    protected boolean draggable = true;
    protected boolean collapsible = true;

    public GPanel(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, "Panel        ");
    }

    public GPanel(PApplet pApplet, float f, float f2, float f3, float f4, String string) {
        super(pApplet, f, f2, f3, f4);
        if (this.x < 0.0f || this.y < 0.0f || this.x + this.width > (float)this.winApp.width || this.y + this.height > (float)this.winApp.height) {
            this.clearDragArea();
        } else {
            this.setDragArea();
        }
        this.children = new LinkedList();
        this.setText(string);
        this.calcHotSpots();
        this.constrainPanelPosition();
        this.opaque = true;
        this.dockX = this.x;
        this.dockY = this.y;
        this.z = 1024;
        this.createEventHandler(G4P.sketchWindow, "handlePanelEvents", new Class[]{GPanel.class, GEvent.class}, new String[]{"panel", "event"});
        this.registeredMethods = 3;
        this.cursorOver = 12;
        G4P.registerControl(this);
    }

    private void calcHotSpots() {
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(COLLAPSED_BAR_SPOT, 0.0f, 0.0f, this.tabWidth, this.tabHeight), new HotSpot.HSrect(EXPANDED_BAR_SPOT, 0.0f, 0.0f, this.width, this.tabHeight), new HotSpot.HSrect(SURFACE_SPOT, 0.0f, this.tabHeight, this.width, this.height - (float)this.tabHeight)};
    }

    @Override
    protected void addToParent(GAbstractControl gAbstractControl) {
        if (this.width > gAbstractControl.width || this.height > gAbstractControl.height) {
            this.draggable = false;
        } else {
            this.lowX = -gAbstractControl.width / 2.0f;
            this.highX = gAbstractControl.width / 2.0f;
            this.lowY = -gAbstractControl.height / 2.0f;
            this.highY = gAbstractControl.height / 2.0f;
            this.dockX = this.x;
            this.dockY = this.y;
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.buffer.beginDraw();
        this.stext.getLines(this.buffer.g2);
        this.buffer.endDraw();
        this.tabHeight = (int)(this.stext.getMaxLineHeight() + 4.0f);
        this.tabWidth = (int)(this.stext.getMaxLineLength() + 8.0f);
        this.calcHotSpots();
        this.bufferInvalid = true;
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            this.localFont = font;
        }
        this.tabHeight = (int)(1.2f * (float)this.localFont.getSize() + 2.0f);
        this.buffer.g2.setFont(this.localFont);
        this.bufferInvalid = true;
        this.calcHotSpots();
        this.bufferInvalid = true;
    }

    @Override
    protected void loseFocus(GAbstractControl gAbstractControl) {
        focusIsWith = null;
        this.beingDragged = false;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.updateBuffer();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        if (this.opaque) {
            this.winApp.pushMatrix();
            this.winApp.translate(-this.halfWidth, -this.halfHeight);
            this.winApp.imageMode(0);
            if (this.alphaLevel < 255) {
                this.winApp.tint(255, (float)this.alphaLevel);
            }
            this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
            this.winApp.popMatrix();
        }
        if (!this.tabOnly && this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            this.buffer.clear();
            this.buffer.noStroke();
            this.buffer.fill(this.palette[4].getRGB());
            if (this.tabOnly) {
                this.buffer.rect(0.0f, 0.0f, (float)this.tabWidth, (float)this.tabHeight);
            } else {
                this.buffer.rect(0.0f, 0.0f, this.width, (float)this.tabHeight);
            }
            this.stext.getLines(graphics2D);
            graphics2D.setColor(this.palette[2]);
            TextLayout textLayout = this.stext.getTLIforLineNo((int)0).layout;
            textLayout.draw(graphics2D, 4.0f, 2.0f + textLayout.getAscent());
            if (!this.tabOnly) {
                this.buffer.noStroke();
                this.buffer.fill(this.palette[5].getRGB());
                this.buffer.rect(0.0f, (float)this.tabHeight, this.width, this.height - (float)this.tabHeight);
            }
            this.buffer.endDraw();
        }
    }

    @Override
    public boolean isOver(float f, float f2) {
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        return this.tabOnly ? this.currSpot == COLLAPSED_BAR_SPOT : this.currSpot == EXPANDED_BAR_SPOT | this.currSpot == COLLAPSED_BAR_SPOT;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        boolean bl2 = this.tabOnly ? this.currSpot == COLLAPSED_BAR_SPOT : (bl = this.currSpot == EXPANDED_BAR_SPOT | this.currSpot == COLLAPSED_BAR_SPOT);
        if (bl || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || !bl || this.z < GPanel.focusObjectZ()) break;
                this.takeFocus();
                this.beingDragged = false;
                break;
            }
            case 3: {
                if (focusIsWith != this || !this.collapsible) break;
                this.tabOnly = !this.tabOnly;
                this.setCollapsed(this.tabOnly);
                if (this.tabOnly) {
                    this.x = this.dockX;
                    this.y = this.dockY;
                } else {
                    this.dockX = this.x;
                    this.dockY = this.y;
                    if (this.y + this.height > (float)this.winApp.height) {
                        this.y = (float)this.winApp.height - this.height;
                    }
                    if (this.x + this.width > (float)this.winApp.width) {
                        this.x = (float)this.winApp.width - this.width;
                    }
                }
                this.cx = this.x + this.width / 2.0f;
                this.cy = this.y + this.height / 2.0f;
                this.constrainPanelPosition();
                if (this.tabOnly) {
                    this.fireEvent(new Object[]{this, GEvent.COLLAPSED});
                } else {
                    this.fireEvent(new Object[]{this, GEvent.EXPANDED});
                }
                this.bufferInvalid = true;
                this.beingDragged = false;
                this.loseFocus(null);
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.beingDragged) break;
                this.dockX = this.x;
                this.dockY = this.y;
                this.beingDragged = false;
                this.loseFocus(null);
                break;
            }
            case 4: {
                if (focusIsWith != this || !this.draggable) break;
                this.cx += (float)(this.winApp.mouseX - this.winApp.pmouseX);
                this.cy += (float)(this.winApp.mouseY - this.winApp.pmouseY);
                this.x = this.cx - this.width / 2.0f;
                this.y = this.cy - this.height / 2.0f;
                this.constrainPanelPosition();
                this.beingDragged = true;
                this.fireEvent(new Object[]{this, GEvent.DRAGGED});
            }
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        if (this.opaque == bl) {
            return;
        }
        if (!bl) {
            this.setCollapsed(false);
            this.setCollapsible(false);
        }
        this.available = bl;
        this.opaque = bl;
    }

    @Override
    public boolean isDragging() {
        return this.beingDragged;
    }

    public void setDraggable(boolean bl) {
        this.draggable = bl;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setCollapsed(boolean bl) {
        if (this.collapsible) {
            this.tabOnly = bl;
            if (this.tabOnly) {
                this.setAvailable(false);
                this.available = true;
            } else {
                this.setAvailable(true);
            }
        }
        this.bufferInvalid = true;
    }

    public boolean isCollapsed() {
        return this.tabOnly;
    }

    public void setCollapsible(boolean bl) {
        this.collapsible = bl;
        if (!bl) {
            this.tabOnly = false;
            this.setAvailable(true);
            this.bufferInvalid = true;
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public int getTabHeight() {
        return this.tabHeight;
    }

    public boolean setDragArea(float f, float f2, float f3, float f4) {
        if (f3 - f < this.width || f4 - f2 < this.height) {
            if (G4P.showMessages) {
                System.out.println("The constraint area is too small for this panel - request ignored");
            }
            return false;
        }
        this.lowX = f;
        this.lowY = f2;
        this.highX = f3;
        this.highY = f4;
        this.constrainPanelPosition();
        return true;
    }

    public boolean setDragArea() {
        return this.setDragArea(0.0f, 0.0f, this.winApp.width, this.winApp.height);
    }

    public void clearDragArea() {
        this.lowY = -3.4028235E38f;
        this.lowX = -3.4028235E38f;
        this.highY = Float.MAX_VALUE;
        this.highX = Float.MAX_VALUE;
    }

    private void constrainPanelPosition() {
        int n = (int)(this.tabOnly ? (float)this.tabWidth : this.width);
        int n2 = (int)(this.tabOnly ? (float)this.tabHeight : this.height);
        if (this.x < this.lowX) {
            this.x = this.lowX;
        } else if (this.x + (float)n > this.highX) {
            this.x = (int)(this.highX - (float)n);
        }
        if (this.y < this.lowY) {
            this.y = this.lowY;
        } else if (this.y + (float)n2 > this.highY) {
            this.y = this.highY - (float)n2;
        }
        this.cx = this.x + this.width / 2.0f;
        this.cy = this.y + this.height / 2.0f;
    }

    @Override
    public String toString() {
        return this.tag + "  [" + this.x + ", " + this.y + "]" + "  [" + this.cx + ", " + this.cy + "]" + "  [" + this.dockX + ", " + this.dockY + "]";
    }
}

